/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.nonce;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.miniauth.oauth.nonce.NonceStore;

public class SimpleNonceStore
implements NonceStore,
Serializable {
    private static final Logger log = Logger.getLogger(SimpleNonceStore.class.getName());
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_MAX_AGE = 864000;
    private final int maxAge;
    private final Map<String, Integer> nonceMap;

    public SimpleNonceStore() {
        this(864000);
    }

    public SimpleNonceStore(int maxAge) {
        this.maxAge = maxAge;
        this.nonceMap = new HashMap<String, Integer>();
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    @Override
    public void store(String nonce, int timestamp) {
        this.nonceMap.put(nonce, timestamp);
    }

    @Override
    public boolean isNew(String nonce, int timestamp) {
        Integer existingTimestamp = this.nonceMap.get(nonce);
        if (existingTimestamp == null) {
            return true;
        }
        int nowSecs = (int)(System.currentTimeMillis() / 1000L);
        if (existingTimestamp < nowSecs - this.maxAge) {
            this.nonceMap.remove(nonce);
            return true;
        }
        return timestamp != existingTimestamp;
    }

    @Override
    public boolean check(String nonce, int timestamp) {
        boolean isNew;
        Integer existingTimestamp = this.nonceMap.get(nonce);
        if (existingTimestamp == null) {
            isNew = true;
        } else {
            int nowSecs = (int)(System.currentTimeMillis() / 1000L);
            isNew = existingTimestamp < nowSecs - this.maxAge ? true : timestamp != existingTimestamp;
        }
        this.nonceMap.put(nonce, timestamp);
        return isNew;
    }

    @Override
    public void clean() {
        int nowSecs = (int)(System.currentTimeMillis() / 1000L);
        for (String n : this.nonceMap.keySet()) {
            Integer t = this.nonceMap.get(n);
            if (t != null && t >= nowSecs - this.maxAge) continue;
            this.nonceMap.remove(n);
        }
    }
}

