/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.common;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.common.BaseURIInfo;
import org.miniauth.common.OutgoingRequest;
import org.miniauth.common.RequestBase;
import org.miniauth.credential.AccessIdentity;
import org.miniauth.exception.AuthSignatureException;
import org.miniauth.exception.InternalErrorException;
import org.miniauth.exception.InvalidInputException;
import org.miniauth.exception.InvalidStateException;
import org.miniauth.oauth.common.OAuthParamMap;
import org.miniauth.oauth.common.OAuthParamMapUtil;
import org.miniauth.oauth.common.OAuthRequestUtil;
import org.miniauth.oauth.credential.OAuthAccessIdentity;
import org.miniauth.oauth.util.ParameterTransmissionUtil;

public class OAuthOutgoingRequest
extends OutgoingRequest {
    private static final Logger log = Logger.getLogger(OAuthOutgoingRequest.class.getName());
    private static final long serialVersionUID = 1L;
    private volatile String authParamTransmissionType = null;
    private boolean endorsed = false;
    private volatile OAuthParamMap oauthParamMap = null;

    protected OAuthOutgoingRequest() {
        this(null, null);
    }

    protected OAuthOutgoingRequest(String httpMethod, URI baseURI) {
        this(httpMethod, baseURI, null, null, null);
    }

    protected OAuthOutgoingRequest(String httpMethod, URI baseURI, Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams) {
        super(httpMethod, baseURI, authHeader, formParams, queryParams);
    }

    protected OAuthOutgoingRequest(RequestBase request) {
        super(request);
    }

    public AccessIdentity getAccessIdentity() throws MiniAuthException {
        this.buildOAuthParamMap();
        return this.oauthParamMap.getAccessIdentity();
    }

    protected OAuthOutgoingRequest setAccessIdentity(AccessIdentity accessIdentity) throws MiniAuthException {
        this.buildOAuthParamMap(accessIdentity);
        return this;
    }

    public String getConumserKey() throws MiniAuthException {
        this.buildOAuthParamMap();
        return this.oauthParamMap.getConsumerKey();
    }

    protected OAuthOutgoingRequest setConsumerKey(String consumerKey) throws MiniAuthException {
        this.buildOAuthParamMap(new OAuthAccessIdentity(consumerKey, null));
        return this;
    }

    public String getAccessToken() throws MiniAuthException {
        this.buildOAuthParamMap();
        return this.oauthParamMap.getToken();
    }

    protected OAuthOutgoingRequest setAccessToken(String accessToken) throws MiniAuthException {
        this.buildOAuthParamMap(new OAuthAccessIdentity(null, accessToken));
        return this;
    }

    protected void initAuthParamTransmissionType() {
        try {
            this.authParamTransmissionType = ParameterTransmissionUtil.getTransmissionType(this.getAuthHeader(), this.getFormParams(), this.getQueryParams());
        }
        catch (MiniAuthException e) {
            log.log(Level.INFO, "Failed to detect authParamTransmissionType.", e);
        }
        if (this.authParamTransmissionType == null) {
            this.authParamTransmissionType = ParameterTransmissionUtil.getDefaultTransmissionType();
        }
    }

    protected void setAuthParamTransmissionType(String authParamTransmissionType) throws MiniAuthException {
        if (this.isEndorsed()) {
            throw new InvalidStateException("The request is already endorsed. authParamTransmissionType cannot be changed.");
        }
        this.authParamTransmissionType = authParamTransmissionType;
    }

    public String getAuthParamTransmissionType() {
        if (!this.isEndorsed()) {
            this.initAuthParamTransmissionType();
        }
        return this.authParamTransmissionType;
    }

    protected void buildOAuthParamMap() throws MiniAuthException {
        this.buildOAuthParamMap(null);
    }

    protected void buildOAuthParamMap(AccessIdentity accessIdentity) throws MiniAuthException {
        this.oauthParamMap = OAuthParamMapUtil.buildOAuthParams(this, accessIdentity);
        this.initAuthParamTransmissionType();
        this.refreshHeadersAndParams();
        this.setReady(true);
    }

    public OAuthParamMap getOauthParamMap() {
        return this.oauthParamMap;
    }

    private void refreshHeadersAndParams() throws MiniAuthException {
        switch (this.authParamTransmissionType) {
            case "header": {
                Map<String, String> newAuthHeader = OAuthRequestUtil.updateOAuthHeaderWithOAuthParamMap(this.getAuthHeader(), this.oauthParamMap);
                this.setAuthHeader(newAuthHeader);
                break;
            }
            case "form": {
                Map<String, String[]> newFormParams = OAuthRequestUtil.updateParamsWithOAuthParamMap(this.getFormParams(), this.oauthParamMap);
                this.setFormParams(newFormParams);
                break;
            }
            case "query": {
                Map<String, String[]> newQueryParams = OAuthRequestUtil.updateParamsWithOAuthParamMap(this.getQueryParams(), this.oauthParamMap);
                this.setQueryParams(newQueryParams);
                break;
            }
            default: {
                throw new InternalErrorException("Invalid authParamTransmissionType: " + this.authParamTransmissionType);
            }
        }
    }

    public OutgoingRequest prepare(AccessIdentity accessIdentity) throws MiniAuthException {
        this.buildOAuthParamMap(accessIdentity);
        this.setReady(true);
        return this;
    }

    public void endorse(OAuthParamMap oauthParamMap) throws MiniAuthException {
        if (this.isEndorsed()) {
            throw new InvalidStateException("The request is already endorsed. Cannot endorse it again.");
        }
        if (!this.isReady()) {
            throw new InvalidStateException("The request is not prepared. Cannot perform endorse().");
        }
        if (this.oauthParamMap == null) {
            this.oauthParamMap = new OAuthParamMap(oauthParamMap);
        } else {
            this.oauthParamMap.updateParams(oauthParamMap);
        }
        if (this.oauthParamMap == null || !this.oauthParamMap.isSignatureSet()) {
            throw new AuthSignatureException("Signature is not set. The request cannot be endorsed.");
        }
        this.refreshHeadersAndParams();
        this.setEndorsed(true);
    }

    public OutgoingRequest endorse(String signature) throws MiniAuthException {
        OAuthParamMap oauthParamMap = new OAuthParamMap();
        oauthParamMap.setSignature(signature);
        this.endorse(oauthParamMap);
        return this;
    }

    public boolean isEndorsed() {
        return this.endorsed;
    }

    protected void setEndorsed(boolean endorsed) {
        this.endorsed = endorsed;
    }

    public String getAuthHeaderAuthorizationString() {
        return this.getAuthHeaderAuthorizationString("OAuth");
    }

    protected RequestBase setHttpMethod(String httpMethod) throws MiniAuthException {
        super.setHttpMethod(httpMethod);
        this.setReady(false);
        return this;
    }

    protected RequestBase setBaseURI(URI baseURI) throws MiniAuthException {
        super.setBaseURI(baseURI);
        this.setReady(false);
        return this;
    }

    protected RequestBase setBaseURI(String baseUri) throws MiniAuthException {
        super.setBaseURI(baseUri);
        this.setReady(false);
        return this;
    }

    protected RequestBase setBaseURI(BaseURIInfo uriInfo) throws MiniAuthException {
        super.setBaseURI(uriInfo);
        this.setReady(false);
        return this;
    }

    protected RequestBase setAuthHeader(String authHeader) throws MiniAuthException {
        super.setAuthHeader(authHeader);
        this.setReady(false);
        return this;
    }

    protected RequestBase setAuthHeaderAuthorizationString(String authHeaderAuthString) throws MiniAuthException {
        super.setAuthHeaderAuthorizationString(authHeaderAuthString, "OAuth");
        this.setReady(false);
        return this;
    }

    protected RequestBase setAuthHeader(Map<String, String> authHeader) throws MiniAuthException {
        super.setAuthHeader(authHeader);
        this.setReady(false);
        return this;
    }

    protected RequestBase addAuthHeaderParam(String key, String value) throws MiniAuthException {
        super.addAuthHeaderParam(key, value);
        this.setReady(false);
        return this;
    }

    protected RequestBase setFormParams(String formBody) throws MiniAuthException {
        super.setFormParams(formBody);
        this.setReady(false);
        return this;
    }

    protected RequestBase setFormParams(Map<String, String[]> formParams) throws MiniAuthException {
        super.setFormParams(formParams);
        this.setReady(false);
        return this;
    }

    protected RequestBase addFormParams(Map<String, String[]> formParams) throws MiniAuthException {
        super.addFormParams(formParams);
        this.setReady(false);
        return this;
    }

    protected RequestBase addFormParam(String key, String value) throws MiniAuthException {
        super.addFormParam(key, value);
        this.setReady(false);
        return this;
    }

    protected RequestBase setQueryParams(String queryString) throws MiniAuthException {
        super.setQueryParams(queryString);
        this.setReady(false);
        return this;
    }

    protected RequestBase setQueryParams(Map<String, String[]> queryParams) throws MiniAuthException {
        super.setQueryParams(queryParams);
        this.setReady(false);
        return this;
    }

    protected RequestBase addQueryParams(Map<String, String[]> queryParams) throws MiniAuthException {
        super.addQueryParams(queryParams);
        this.setReady(false);
        return this;
    }

    protected RequestBase addQueryParam(String key, String value) throws MiniAuthException {
        super.addQueryParam(key, value);
        this.setReady(false);
        return this;
    }

    public HttpURLConnection openEndorsedURLConnection() throws MiniAuthException, IOException {
        if (!this.isEndorsed()) {
            throw new InvalidStateException("The request has not been endorsed/signed. Cannot open a URLConnection.");
        }
        URL url = this.getURL();
        if (url == null) {
            throw new InvalidInputException("Failed to build URL from this request object.");
        }
        URLConnection urlConn = url.openConnection();
        HttpURLConnection httpConn = null;
        try {
            httpConn = (HttpURLConnection)urlConn;
        }
        catch (Exception e) {
            throw new InvalidInputException("Failed to get HttpURLConnection from this request object.", (Throwable)e);
        }
        httpConn.setRequestMethod(this.getHttpMethod());
        if (this.getAuthHeader() != null && !this.getAuthHeader().isEmpty()) {
            String authHeaderStr = this.getAuthHeaderAuthorizationString();
            httpConn.setRequestProperty("Authorization", authHeaderStr);
        }
        if (this.getFormParams() != null && !this.getFormParams().isEmpty()) {
            httpConn.setRequestMethod("POST");
            httpConn.setDoOutput(true);
            httpConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            String formBody = this.getFormParamString();
            OutputStreamWriter out = new OutputStreamWriter(httpConn.getOutputStream());
            out.write(formBody);
        }
        return httpConn;
    }

    public String toString() {
        return "OAuthOutgoingRequest [authParamTransmissionType=" + this.authParamTransmissionType + ", endorsed=" + this.endorsed + ", oauthParamMap=" + this.oauthParamMap + ", getHttpMethod()=" + this.getHttpMethod() + ", getBaseURI()=" + this.getBaseURI() + ", getAuthHeader()=" + this.getAuthHeader() + ", getFormParams()=" + this.getFormParams() + ", getQueryParams()=" + this.getQueryParams() + "]";
    }
}

