/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.credential.mapper;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.miniauth.credential.AccessCredential;
import org.miniauth.credential.AccessIdentity;
import org.miniauth.credential.ConsumerCredential;
import org.miniauth.exception.CredentialStoreException;
import org.miniauth.oauth.credential.OAuthAccessCredential;
import org.miniauth.oauth.credential.OAuthAccessIdentity;
import org.miniauth.oauth.credential.OAuthConsumerCredential;
import org.miniauth.oauth.credential.mapper.AbstractOAuthCredentialMapper;
import org.miniauth.oauth.credential.mapper.DynamicOAuthTokenCredentialMapper;

public class OAuthLocalTokenCredentialMapper
extends AbstractOAuthCredentialMapper
implements DynamicOAuthTokenCredentialMapper {
    private static final Logger log = Logger.getLogger(OAuthLocalTokenCredentialMapper.class.getName());
    private static final long serialVersionUID = 1L;
    private final Map<String, String> tokenRegistry = new HashMap<String, String>();
    private String consumerKey = null;
    private String consumerSecret = null;

    public OAuthLocalTokenCredentialMapper() {
        this(null, null);
    }

    public OAuthLocalTokenCredentialMapper(String consumerKey, String consumerSecret) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
    }

    @Override
    protected void init() {
    }

    @Deprecated
    public static OAuthLocalTokenCredentialMapper getInstance() {
        return OAuthLocalCredentialMapperHolder.INSTANCE;
    }

    @Override
    public String getConsumerKey() {
        return this.consumerKey;
    }

    public OAuthLocalTokenCredentialMapper setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
        return this;
    }

    @Override
    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public OAuthLocalTokenCredentialMapper setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
        return this;
    }

    @Override
    public ConsumerCredential getConsumerCredential() {
        return new OAuthConsumerCredential(this.getConsumerKey(), this.getConsumerSecret());
    }

    public String getCredentialSecret(String credentialType, String credentialKey) throws CredentialStoreException {
        if ("consumerCredential".equals(credentialType)) {
            return this.consumerSecret;
        }
        if ("tokenCredential".equals(credentialType)) {
            return this.tokenRegistry.get(credentialKey);
        }
        return null;
    }

    public String putCredentialSecret(String credentialType, String credentialKey, String credentialSecret) throws CredentialStoreException {
        if ("consumerCredential".equals(credentialType)) {
            String oldConsumerSecret = this.consumerSecret;
            this.consumerSecret = credentialSecret;
            return oldConsumerSecret;
        }
        if ("tokenCredential".equals(credentialType)) {
            return this.tokenRegistry.put(credentialKey, credentialSecret);
        }
        return null;
    }

    @Override
    public String getTokenSecret(String accessToken) throws CredentialStoreException {
        return this.tokenRegistry.get(accessToken);
    }

    @Override
    public String putTokenSecret(String accessToken, String tokenSecret) throws CredentialStoreException {
        return this.tokenRegistry.put(accessToken, tokenSecret);
    }

    @Override
    public void putTokenSecrets(Map<String, String> tokenCredentials) throws CredentialStoreException {
        this.tokenRegistry.putAll(tokenCredentials);
    }

    @Override
    public AccessIdentity getAccessIdentity(String accessToken) throws CredentialStoreException {
        return new OAuthAccessIdentity(this.getConsumerKey(), accessToken);
    }

    @Override
    public AccessCredential getAccesssCredential(String accessToken) throws CredentialStoreException {
        return new OAuthAccessCredential(this.getConsumerSecret(), this.getTokenSecret(accessToken));
    }

    @Override
    public AccessCredential putAccesssCredential(String accessToken, String tokenSecret) throws CredentialStoreException {
        String oldSecret = this.tokenRegistry.put(accessToken, tokenSecret);
        return new OAuthAccessCredential(this.getConsumerSecret(), oldSecret);
    }

    private static final class OAuthLocalCredentialMapperHolder {
        private static final OAuthLocalTokenCredentialMapper INSTANCE = new OAuthLocalTokenCredentialMapper();

        private OAuthLocalCredentialMapperHolder() {
        }
    }
}

