/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.credential.mapper;

import java.util.Map;
import java.util.logging.Logger;
import org.miniauth.credential.AccessCredential;
import org.miniauth.credential.AccessIdentity;
import org.miniauth.credential.ConsumerCredential;
import org.miniauth.exception.CredentialStoreException;
import org.miniauth.oauth.credential.OAuthAccessCredential;
import org.miniauth.oauth.credential.OAuthAccessIdentity;
import org.miniauth.oauth.credential.OAuthConsumerCredential;
import org.miniauth.oauth.credential.mapper.AbstractOAuthCredentialMapper;
import org.miniauth.oauth.credential.mapper.DynamicOAuthTokenCredentialMapper;

public final class OAuthNullTokenCredentialMapper
extends AbstractOAuthCredentialMapper
implements DynamicOAuthTokenCredentialMapper {
    private static final Logger log = Logger.getLogger(OAuthNullTokenCredentialMapper.class.getName());
    private static final long serialVersionUID = 1L;
    private final String consumerKey;
    private final String consumerSecret;

    public OAuthNullTokenCredentialMapper(String consumerKey, String consumerSecret) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
    }

    @Override
    protected void init() {
    }

    @Override
    public String getConsumerKey() {
        return this.consumerKey;
    }

    @Override
    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    @Override
    public ConsumerCredential getConsumerCredential() {
        return new OAuthConsumerCredential(this.getConsumerKey(), this.getConsumerSecret());
    }

    public String getCredentialSecret(String credentialType, String credentialKey) throws CredentialStoreException {
        if ("consumerCredential".equals(credentialType)) {
            return this.consumerSecret;
        }
        if ("tokenCredential".equals(credentialType)) {
            return null;
        }
        return null;
    }

    public String putCredentialSecret(String credentialType, String credentialKey, String credentialSecret) throws CredentialStoreException {
        if ("consumerCredential".equals(credentialType)) {
            return this.consumerSecret;
        }
        if ("tokenCredential".equals(credentialType)) {
            return null;
        }
        return null;
    }

    @Override
    public String getTokenSecret(String accessToken) throws CredentialStoreException {
        return null;
    }

    @Override
    public String putTokenSecret(String accessToken, String tokenSecret) throws CredentialStoreException {
        return null;
    }

    @Override
    public void putTokenSecrets(Map<String, String> tokenCredentials) throws CredentialStoreException {
    }

    @Override
    public AccessIdentity getAccessIdentity(String accessToken) throws CredentialStoreException {
        return new OAuthAccessIdentity(this.getConsumerKey(), accessToken);
    }

    @Override
    public AccessCredential getAccesssCredential(String accessToken) throws CredentialStoreException {
        return new OAuthAccessCredential(this.getConsumerSecret(), this.getTokenSecret(accessToken));
    }

    @Override
    public AccessCredential putAccesssCredential(String accessToken, String tokenSecret) throws CredentialStoreException {
        String oldSecret = null;
        return new OAuthAccessCredential(this.getConsumerSecret(), oldSecret);
    }
}

