/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.credential.mapper;

import java.util.Map;
import java.util.logging.Logger;
import org.miniauth.credential.AccessCredential;
import org.miniauth.credential.AccessIdentity;
import org.miniauth.credential.ConsumerCredential;
import org.miniauth.exception.CredentialStoreException;
import org.miniauth.oauth.credential.OAuthAccessCredential;
import org.miniauth.oauth.credential.OAuthAccessIdentity;
import org.miniauth.oauth.credential.OAuthConsumerCredential;
import org.miniauth.oauth.credential.mapper.AbstractOAuthCredentialMapper;
import org.miniauth.oauth.credential.mapper.DynamicOAuthConsumerCredentialMapper;

public class OAuthSingleConsumerCredentialMapper
extends AbstractOAuthCredentialMapper
implements DynamicOAuthConsumerCredentialMapper {
    private static final Logger log = Logger.getLogger(OAuthSingleConsumerCredentialMapper.class.getName());
    private static final long serialVersionUID = 1L;
    private String consumerKey = null;
    private String consumerSecret = null;

    public OAuthSingleConsumerCredentialMapper() {
        this(null, null);
    }

    public OAuthSingleConsumerCredentialMapper(String consumerKey, String consumerSecret) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
    }

    @Override
    protected void init() {
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public OAuthSingleConsumerCredentialMapper setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
        return this;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    @Override
    public String putConsumerSecret(String consumerKey, String consumerSecret) throws CredentialStoreException {
        this.consumerKey = consumerKey;
        String oldSecret = this.consumerSecret;
        this.consumerSecret = consumerSecret;
        return oldSecret;
    }

    @Override
    public void putConsumerSecrets(Map<String, String> consumerCredentials) throws CredentialStoreException {
        throw new CredentialStoreException("Not a valid method for OAuthSingleConsumerCredentialMapper.");
    }

    public ConsumerCredential getConsumerCredential() {
        return new OAuthConsumerCredential(this.getConsumerKey(), this.getConsumerSecret());
    }

    public String getCredentialSecret(String credentialType, String credentialKey) throws CredentialStoreException {
        if ("consumerCredential".equals(credentialType)) {
            return this.consumerSecret;
        }
        if ("tokenCredential".equals(credentialType)) {
            return null;
        }
        return null;
    }

    public String putCredentialSecret(String credentialType, String credentialKey, String credentialSecret) throws CredentialStoreException {
        if ("consumerCredential".equals(credentialType)) {
            String oldConsumerSecret = this.consumerSecret;
            this.consumerSecret = credentialSecret;
            return oldConsumerSecret;
        }
        if ("tokenCredential".equals(credentialType)) {
            return null;
        }
        return null;
    }

    @Override
    public String getTokenSecret(String accessToken) throws CredentialStoreException {
        return null;
    }

    @Override
    public String putTokenSecret(String accessToken, String tokenSecret) throws CredentialStoreException {
        return null;
    }

    public AccessIdentity getAccessIdentity() throws CredentialStoreException {
        return new OAuthAccessIdentity(this.getConsumerKey(), null);
    }

    public AccessCredential getAccesssCredential() throws CredentialStoreException {
        return new OAuthAccessCredential(this.getConsumerSecret(), null);
    }

    @Override
    public AccessCredential getAccesssCredential(String consumerKey) throws CredentialStoreException {
        return this.getAccesssCredential();
    }

    @Override
    public AccessCredential putAccesssCredential(String accessToken, String tokenSecret) throws CredentialStoreException {
        throw new CredentialStoreException("Not a valid method for OAuthSingleConsumerCredentialMapper.");
    }
}

