/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.crypto;

import java.util.Map;
import org.miniauth.MiniAuthException;
import org.miniauth.credential.AccessCredential;
import org.miniauth.crypto.HmacSHA1SignatureAlgorithm;
import org.miniauth.crypto.SignatureAlgorithm;
import org.miniauth.exception.AuthSignatureException;
import org.miniauth.exception.InvalidCredentialException;
import org.miniauth.oauth.common.OAuthParamMap;
import org.miniauth.oauth.crypto.AbstractOAuthSignatureAlgorithm;
import org.miniauth.oauth.crypto.OAuthSignatureAlgorithm;
import org.miniauth.oauth.util.OAuthSignatureUtil;

public class HmacSHA1OAuthSignatureAlgorithm
extends AbstractOAuthSignatureAlgorithm
implements OAuthSignatureAlgorithm {
    public HmacSHA1OAuthSignatureAlgorithm() {
        HmacSHA1SignatureAlgorithm algorithm = new HmacSHA1SignatureAlgorithm();
        this.setSignatureAlgorithm((SignatureAlgorithm)algorithm);
    }

    @Override
    public String generate(String text, AccessCredential credential) throws AuthSignatureException, InvalidCredentialException {
        String key = this.buildKeyString(credential);
        return this.getSignatureAlgorithm().generate(text, key);
    }

    @Override
    public OAuthParamMap generateOAuthParamMap(String text, AccessCredential credential, Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams) throws MiniAuthException {
        Map<String, String[]> requestParams = OAuthSignatureUtil.mergeRequestParameters(formParams, queryParams);
        return this.generateOAuthParamMap(text, credential, authHeader, requestParams);
    }

    @Override
    public OAuthParamMap generateOAuthParamMap(String text, AccessCredential credential, Map<String, String> authHeader, Map<String, String[]> requestParams) throws MiniAuthException {
        Map<String, String> oauthParams = OAuthSignatureUtil.getOAuthParams(authHeader, requestParams);
        OAuthParamMap oauthParamMap = new OAuthParamMap(oauthParams);
        String signature = this.generate(text, credential);
        oauthParamMap.setSignature(signature);
        return oauthParamMap;
    }
}

