/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.service;

import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.common.OutgoingRequest;
import org.miniauth.credential.AccessCredential;
import org.miniauth.credential.AccessIdentity;
import org.miniauth.exception.InvalidCredentialException;
import org.miniauth.oauth.common.OAuthOutgoingRequest;
import org.miniauth.oauth.credential.OAuthAccessIdentity;
import org.miniauth.oauth.credential.mapper.OAuthSingleConsumerCredentialMapper;
import org.miniauth.oauth.service.OAuthCredentialService;
import org.miniauth.oauth.service.OAuthRequestEndorser;
import org.miniauth.service.EndorserService;

public class OAuthSingleConsumerEndorserService
extends OAuthCredentialService
implements EndorserService {
    private static final Logger log = Logger.getLogger(OAuthSingleConsumerEndorserService.class.getName());
    private static final long serialVersionUID = 1L;

    public OAuthSingleConsumerEndorserService(OAuthSingleConsumerCredentialMapper credentialMapper) {
        super(credentialMapper);
    }

    public OAuthSingleConsumerCredentialMapper getOAuthSingleConsumerCredentialMapper() {
        return (OAuthSingleConsumerCredentialMapper)this.getOAuthCredentialMapper();
    }

    public AccessIdentity getAccessIdentity() {
        return new OAuthAccessIdentity(this.getOAuthSingleConsumerCredentialMapper().getConsumerKey(), null);
    }

    public boolean endorse(OutgoingRequest request) throws MiniAuthException {
        String requestConsumerKey = ((OAuthOutgoingRequest)request).getConumserKey();
        String consumerKey = this.getOAuthSingleConsumerCredentialMapper().getConsumerKey();
        AccessCredential accessCredential = this.getOAuthSingleConsumerCredentialMapper().getAccesssCredential();
        if (accessCredential == null || accessCredential.getTokenSecret() == null) {
            throw new InvalidCredentialException("AccessCredential not found.");
        }
        return OAuthRequestEndorser.getInstance().endorse(accessCredential, request);
    }
}

