/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.signature;

import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.common.BaseURIInfo;
import org.miniauth.exception.UnauthorizedException;
import org.miniauth.oauth.common.OAuthParamMap;
import org.miniauth.oauth.core.SignatureMethod;
import org.miniauth.oauth.credential.OAuthAccessCredential;
import org.miniauth.oauth.credential.OAuthAccessIdentity;
import org.miniauth.oauth.crypto.OAuthSignatureAlgorithm;
import org.miniauth.oauth.crypto.OAuthSignatureAlgorithmFactory;
import org.miniauth.oauth.nonce.NonceStore;
import org.miniauth.oauth.nonce.NonceStorePool;
import org.miniauth.oauth.signature.OAuthSignatureBase;
import org.miniauth.oauth.util.OAuthSignatureUtil;
import org.miniauth.signature.SignatureVerifier;

public class OAuthSignatureVerifier
extends OAuthSignatureBase
implements SignatureVerifier {
    private static final Logger log = Logger.getLogger(OAuthSignatureVerifier.class.getName());
    private static final long serialVersionUID = 1L;

    public boolean verify(Map<String, String> authCredential, String httpMethod, URI baseUri, Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams) throws MiniAuthException {
        Map<String, String[]> requestParams = OAuthSignatureUtil.mergeRequestParameters(formParams, queryParams);
        return this.verify(authCredential, httpMethod, baseUri, authHeader, requestParams);
    }

    public boolean verify(Map<String, String> authCredential, String httpMethod, URI baseUri, Map<String, String> authHeader, Map<String, String[]> requestParams) throws MiniAuthException {
        OAuthParamMap oauthParamMap = OAuthSignatureUtil.validateOAuthParams(authHeader, requestParams);
        String signatureMethod = oauthParamMap.getSignatureMethod();
        if (SignatureMethod.requiresNonceAndTimestamp(signatureMethod)) {
            NonceStore nonceStore;
            boolean isNonceNew;
            String nonce = oauthParamMap.getNonce();
            int timestamp = oauthParamMap.getTimestamp();
            OAuthAccessIdentity identity = null;
            if (authCredential != null) {
                String consumerKey = null;
                if (authCredential.containsKey("consumerKey")) {
                    consumerKey = authCredential.get("consumerKey");
                }
                String accessToken = null;
                if (authCredential.containsKey("accessToken")) {
                    accessToken = authCredential.get("accessToken");
                }
                identity = new OAuthAccessIdentity(consumerKey, accessToken);
            }
            if (!(isNonceNew = (nonceStore = NonceStorePool.getInstance().getNonceStore(identity)).check(nonce, timestamp))) {
                throw new UnauthorizedException("Nonce has been used before: nonce = " + nonce + "; timestamp = " + timestamp);
            }
        }
        String signature = oauthParamMap.getSignature();
        OAuthAccessCredential accessCredential = null;
        if (authCredential != null) {
            String consumerSecret = null;
            if (authCredential.containsKey("consumerSecret")) {
                consumerSecret = authCredential.get("consumerSecret");
            }
            String tokenSecret = null;
            if (authCredential.containsKey("tokenSecret")) {
                tokenSecret = authCredential.get("tokenSecret");
            }
            accessCredential = new OAuthAccessCredential(consumerSecret, tokenSecret);
        }
        OAuthSignatureAlgorithm oauthSignatureAlgorithm = OAuthSignatureAlgorithmFactory.getInstance().getOAuthSignatureAlgorithm(signatureMethod);
        boolean verified = false;
        if ("PLAINTEXT".equals(signatureMethod)) {
            verified = oauthSignatureAlgorithm.verify(null, accessCredential, signature);
        } else {
            BaseURIInfo uriInfo = new BaseURIInfo(baseUri);
            String signatureBaseString = this.buildSignatureBaseString(httpMethod, uriInfo, authHeader, requestParams);
            verified = oauthSignatureAlgorithm.verify(signatureBaseString, accessCredential, signature);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("verified = " + verified);
        }
        if (!verified) {
            throw new UnauthorizedException("Signaure is incorrect. Request signature = " + signature);
        }
        return true;
    }
}

