/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.common;

import java.net.URI;
import java.util.Map;
import org.miniauth.MiniAuthException;
import org.miniauth.common.BaseURIInfo;
import org.miniauth.common.RequestBase;
import org.miniauth.credential.AccessIdentity;
import org.miniauth.oauth.common.OAuthOutgoingRequest;
import org.miniauth.oauth.credential.OAuthAccessIdentity;

public final class OAuthOutgoingRequestBuilder {
    private OAuthOutgoingRequest outgoingRequest;

    public OAuthOutgoingRequestBuilder() {
        this.init();
    }

    public OAuthOutgoingRequestBuilder init() {
        return this.init(null);
    }

    public OAuthOutgoingRequestBuilder init(OAuthOutgoingRequest outgoingRequest) {
        this.outgoingRequest = new OAuthOutgoingRequest((RequestBase)outgoingRequest);
        return this;
    }

    public OAuthOutgoingRequestBuilder setAccessIdentity(AccessIdentity accessIdentity) throws MiniAuthException {
        this.outgoingRequest.buildOAuthParamMap(accessIdentity);
        return this;
    }

    public OAuthOutgoingRequestBuilder setConsumerKey(String consumerKey) throws MiniAuthException {
        this.outgoingRequest.buildOAuthParamMap(new OAuthAccessIdentity(consumerKey, null));
        return this;
    }

    public OAuthOutgoingRequestBuilder setAccessToken(String accessToken) throws MiniAuthException {
        this.outgoingRequest.buildOAuthParamMap(new OAuthAccessIdentity(null, accessToken));
        return this;
    }

    public OAuthOutgoingRequestBuilder setHttpMethod(String httpMethod) throws MiniAuthException {
        this.outgoingRequest.setHttpMethod(httpMethod);
        return this;
    }

    public OAuthOutgoingRequestBuilder setBaseURI(URI baseURI) throws MiniAuthException {
        this.outgoingRequest.setBaseURI(baseURI);
        return this;
    }

    public OAuthOutgoingRequestBuilder setBaseURI(String baseUri) throws MiniAuthException {
        this.outgoingRequest.setBaseURI(baseUri);
        return this;
    }

    public OAuthOutgoingRequestBuilder setBaseURI(BaseURIInfo uriInfo) throws MiniAuthException {
        this.outgoingRequest.setBaseURI(uriInfo);
        return this;
    }

    public OAuthOutgoingRequestBuilder setAuthHeader(String authHeader) throws MiniAuthException {
        this.outgoingRequest.setAuthHeader(authHeader);
        return this;
    }

    public OAuthOutgoingRequestBuilder setAuthHeaderAuthorizationString(String authHeaderStr) throws MiniAuthException {
        this.outgoingRequest.setAuthHeaderAuthorizationString(authHeaderStr);
        return this;
    }

    public OAuthOutgoingRequestBuilder setAuthHeader(Map<String, String> authHeader) throws MiniAuthException {
        this.outgoingRequest.setAuthHeader(authHeader);
        return this;
    }

    public OAuthOutgoingRequestBuilder addAuthHeaderParam(String key, String value) throws MiniAuthException {
        this.outgoingRequest.addAuthHeaderParam(key, value);
        return this;
    }

    public OAuthOutgoingRequestBuilder setFormParams(String formBody) throws MiniAuthException {
        this.outgoingRequest.setFormParams(formBody);
        return this;
    }

    public OAuthOutgoingRequestBuilder setFormParams(Map<String, String[]> formParams) throws MiniAuthException {
        this.outgoingRequest.setFormParams(formParams);
        return this;
    }

    public OAuthOutgoingRequestBuilder addFormParams(Map<String, String[]> formParams) throws MiniAuthException {
        this.outgoingRequest.addFormParams(formParams);
        return this;
    }

    public OAuthOutgoingRequestBuilder addFormParam(String key, String value) throws MiniAuthException {
        this.outgoingRequest.addFormParam(key, value);
        return this;
    }

    public OAuthOutgoingRequestBuilder setQueryParams(String queryString) throws MiniAuthException {
        this.outgoingRequest.setQueryParams(queryString);
        return this;
    }

    public OAuthOutgoingRequestBuilder setQueryParams(Map<String, String[]> queryParams) throws MiniAuthException {
        this.outgoingRequest.setQueryParams(queryParams);
        return this;
    }

    public OAuthOutgoingRequestBuilder addQueryParams(Map<String, String[]> queryParams) throws MiniAuthException {
        this.outgoingRequest.addQueryParams(queryParams);
        return this;
    }

    public OAuthOutgoingRequestBuilder addQueryParam(String key, String value) throws MiniAuthException {
        this.outgoingRequest.addQueryParam(key, value);
        return this;
    }

    public OAuthOutgoingRequest build() throws MiniAuthException {
        return this.build(null);
    }

    public OAuthOutgoingRequest build(AccessIdentity accessIdentity) throws MiniAuthException {
        this.outgoingRequest.prepare(accessIdentity);
        return this.outgoingRequest;
    }
}

