/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.credential;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.miniauth.credential.AccessIdentity;

public final class OAuthAccessIdentity
implements AccessIdentity,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String consumerKey;
    private final String accessToken;

    public OAuthAccessIdentity(Map<String, String> authCredential) {
        this(authCredential != null ? authCredential.get("consumerKey") : null, authCredential != null ? authCredential.get("accessToken") : null);
    }

    public OAuthAccessIdentity(String consumerKey, String accessToken) {
        this.consumerKey = consumerKey;
        this.accessToken = accessToken;
    }

    public Map<String, String> toReadOnlyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("consumerKey", this.consumerKey);
        map.put("accessToken", this.accessToken);
        return map;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessToken == null ? 0 : this.accessToken.hashCode());
        result = 31 * result + (this.consumerKey == null ? 0 : this.consumerKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuthAccessIdentity other = (OAuthAccessIdentity)obj;
        if (this.accessToken == null ? other.accessToken != null : !this.accessToken.equals(other.accessToken)) {
            return false;
        }
        return !(this.consumerKey == null ? other.consumerKey != null : !this.consumerKey.equals(other.consumerKey));
    }

    public String toString() {
        return "OAuthAccessIdentity [consumerKey=" + this.consumerKey + ", accessToken=" + this.accessToken + "]";
    }
}

