/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.credential;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.miniauth.credential.ConsumerCredential;

public final class OAuthConsumerCredential
implements ConsumerCredential,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String consumerKey;
    private final String consumerSecret;

    public OAuthConsumerCredential(Map<String, String> authCredential) {
        this(authCredential != null ? authCredential.get("consumerKey") : null, authCredential != null ? authCredential.get("consumerSecret") : null);
    }

    public OAuthConsumerCredential(String consumerKey, String consumerSecret) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
    }

    public Map<String, String> toReadOnlyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("consumerKey", this.consumerKey);
        map.put("consumerSecret", this.consumerSecret);
        return map;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.consumerKey == null ? 0 : this.consumerKey.hashCode());
        result = 31 * result + (this.consumerSecret == null ? 0 : this.consumerSecret.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuthConsumerCredential other = (OAuthConsumerCredential)obj;
        if (this.consumerKey == null ? other.consumerKey != null : !this.consumerKey.equals(other.consumerKey)) {
            return false;
        }
        return !(this.consumerSecret == null ? other.consumerSecret != null : !this.consumerSecret.equals(other.consumerSecret));
    }

    public String toString() {
        return "OAuthConsumerCredential [consumerKey=" + this.consumerKey + ", consumerSecret=" + this.consumerSecret + "]";
    }
}

