/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.credential;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.miniauth.credential.TokenCredential;

public final class OAuthTokenCredential
implements TokenCredential,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String accessToken;
    private final String tokenSecret;

    public OAuthTokenCredential(Map<String, String> authCredential) {
        this(authCredential != null ? authCredential.get("accessToken") : null, authCredential != null ? authCredential.get("tokenSecret") : null);
    }

    public OAuthTokenCredential(String accessToken, String tokenSecret) {
        this.accessToken = accessToken;
        this.tokenSecret = tokenSecret;
    }

    public Map<String, String> toReadOnlyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("accessToken", this.accessToken);
        map.put("tokenSecret", this.tokenSecret);
        return map;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessToken == null ? 0 : this.accessToken.hashCode());
        result = 31 * result + (this.tokenSecret == null ? 0 : this.tokenSecret.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuthTokenCredential other = (OAuthTokenCredential)obj;
        if (this.accessToken == null ? other.accessToken != null : !this.accessToken.equals(other.accessToken)) {
            return false;
        }
        return !(this.tokenSecret == null ? other.tokenSecret != null : !this.tokenSecret.equals(other.tokenSecret));
    }

    public String toString() {
        return "OAuthTokenCredential [accessToken=" + this.accessToken + ", tokenSecret=" + this.tokenSecret + "]";
    }
}

