/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.nonce;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.miniauth.credential.AccessIdentity;
import org.miniauth.oauth.nonce.NonceStore;
import org.miniauth.oauth.nonce.SimpleNonceStore;

public final class NonceStorePool {
    private static final Logger log = Logger.getLogger(NonceStorePool.class.getName());
    private final Map<AccessIdentity, NonceStore> nonceStoreMap = new HashMap<AccessIdentity, NonceStore>();

    private NonceStorePool() {
    }

    public static NonceStorePool getInstance() {
        return NonceStorePoolHolder.INSTANCE;
    }

    public NonceStore getNonceStore(AccessIdentity identity) {
        if (this.nonceStoreMap.containsKey(identity)) {
            return this.nonceStoreMap.get(identity);
        }
        SimpleNonceStore nonceStore = new SimpleNonceStore();
        this.nonceStoreMap.put(identity, nonceStore);
        return nonceStore;
    }

    public NonceStore putNonceStore(NonceStore nonceStore) {
        return this.putNonceStore(null, nonceStore);
    }

    public NonceStore putNonceStore(AccessIdentity identity, NonceStore nonceStore) {
        nonceStore = this.nonceStoreMap.put(identity, nonceStore);
        return nonceStore;
    }

    private static final class NonceStorePoolHolder {
        private static final NonceStorePool INSTANCE = new NonceStorePool();

        private NonceStorePoolHolder() {
        }
    }
}

