/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.service;

import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.common.OutgoingRequest;
import org.miniauth.credential.AccessCredential;
import org.miniauth.credential.AccessIdentity;
import org.miniauth.exception.InvalidCredentialException;
import org.miniauth.oauth.common.OAuthOutgoingRequest;
import org.miniauth.oauth.credential.mapper.OAuthTokenCredentialMapper;
import org.miniauth.oauth.service.OAuthCredentialService;
import org.miniauth.oauth.service.OAuthRequestEndorser;
import org.miniauth.service.EndorserService;

public class OAuthEndorserService
extends OAuthCredentialService
implements EndorserService {
    private static final Logger log = Logger.getLogger(OAuthEndorserService.class.getName());
    private static final long serialVersionUID = 1L;

    public OAuthEndorserService(OAuthTokenCredentialMapper credentialMapper) {
        super(credentialMapper);
    }

    public OAuthTokenCredentialMapper getOAuthTokenCredentialMapper() {
        return (OAuthTokenCredentialMapper)this.getOAuthCredentialMapper();
    }

    public boolean endorse(OutgoingRequest request) throws MiniAuthException {
        AccessIdentity accessIdentity = ((OAuthOutgoingRequest)request).getAccessIdentity();
        AccessCredential accessCredential = this.getOAuthCredentialMapper().getAccesssCredential(accessIdentity);
        if (accessCredential == null || accessCredential.getConsumerSecret() == null && accessCredential.getTokenSecret() == null) {
            throw new InvalidCredentialException("AccessCredential not found.");
        }
        return OAuthRequestEndorser.getInstance().endorse(accessCredential, request);
    }
}

