/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.signature;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.common.BaseURIInfo;
import org.miniauth.exception.BadRequestException;
import org.miniauth.exception.ValidationException;
import org.miniauth.oauth.core.OAuthConstants;
import org.miniauth.oauth.signature.BytewiseComparator;
import org.miniauth.oauth.util.PercentEncoder;

public abstract class OAuthSignatureBase
implements Serializable {
    private static final Logger log = Logger.getLogger(OAuthSignatureBase.class.getName());
    private static final long serialVersionUID = 1L;

    protected OAuthSignatureBase() {
    }

    protected String buildSignatureBaseString(String httpMethod, BaseURIInfo uriInfo, Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams) throws MiniAuthException {
        String requestParamString = this.normalizeRequestParameters(authHeader, formParams, queryParams);
        return this.buildSignatureBaseString(httpMethod, uriInfo, requestParamString);
    }

    protected String buildSignatureBaseString(String httpMethod, BaseURIInfo uriInfo, Map<String, String> authHeader, Map<String, String[]> requestParams) throws MiniAuthException {
        String requestParamString = this.normalizeRequestParameters(authHeader, requestParams);
        return this.buildSignatureBaseString(httpMethod, uriInfo, requestParamString);
    }

    private String buildSignatureBaseString(String httpMethod, BaseURIInfo uriInfo, String requestParamString) throws MiniAuthException {
        StringBuilder sb = new StringBuilder();
        sb.append(httpMethod.toUpperCase(Locale.US)).append("&");
        String baseUriString = uriInfo.buildURIString();
        if (log.isLoggable(Level.FINER)) {
            log.finer("baseUriString = " + baseUriString);
        }
        String encBaseUriString = PercentEncoder.encode(baseUriString);
        sb.append(encBaseUriString).append("&");
        if (requestParamString == null) {
            throw new BadRequestException("Failed to generate the request param string.");
        }
        sb.append(requestParamString);
        String signatureBaseString = sb.toString();
        if (log.isLoggable(Level.FINE)) {
            log.fine("signatureBaseString = " + signatureBaseString);
        }
        return signatureBaseString;
    }

    private String normalizePercentEncodedParamMap(Map<String, List<String>> paramMap) throws MiniAuthException {
        if (paramMap == null) {
            return null;
        }
        BytewiseComparator byteComparator = new BytewiseComparator();
        StringBuilder sb = new StringBuilder();
        TreeSet<String> sortedKeys = new TreeSet<String>(byteComparator);
        sortedKeys.addAll(paramMap.keySet());
        for (String eKey : sortedKeys) {
            List<String> eValues = paramMap.get(eKey);
            if (eValues == null || eValues.isEmpty()) {
                sb.append(eKey).append("=").append("&");
                continue;
            }
            Collections.sort(eValues, byteComparator);
            for (String eVal : eValues) {
                sb.append(eKey).append("=").append(eVal).append("&");
            }
        }
        String paramString = null;
        int buffLen = sb.length();
        paramString = buffLen > 0 && sb.charAt(buffLen - 1) == '&' ? sb.substring(0, buffLen - 1) : sb.toString();
        if (log.isLoggable(Level.FINER)) {
            log.finer("paramString = " + paramString);
        }
        return paramString;
    }

    protected String normalizeRequestParameters(Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams) throws MiniAuthException {
        Map<String, List<String>> paramMap = this.percentEncodeRequestParams(authHeader, formParams, queryParams);
        return this.normalizePercentEncodedParamMap(paramMap);
    }

    protected String normalizeRequestParameters(Map<String, String> authHeader, Map<String, String[]> requestParams) throws MiniAuthException {
        Map<String, List<String>> paramMap = this.percentEncodeRequestParams(authHeader, requestParams);
        return this.normalizePercentEncodedParamMap(paramMap);
    }

    protected Map<String, List<String>> percentEncodeRequestParams(Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams) throws MiniAuthException {
        String encodedValue;
        String encodedKey;
        ArrayList<String> encodedList;
        boolean oauthParamFoundInHeader = false;
        HashMap<String, List<String>> paramMap = null;
        if (authHeader != null) {
            paramMap = new HashMap<String, List<String>>();
            for (String h : authHeader.keySet()) {
                if (OAuthConstants.isOAuthParam(h)) {
                    oauthParamFoundInHeader = true;
                }
                if ("oauth_signature".equals(h) || "realm".equals(h)) continue;
                String encodedKey2 = PercentEncoder.encode(h);
                String value = authHeader.get(h);
                encodedList = null;
                if (value != null) {
                    encodedList = new ArrayList<String>();
                    String encodedValue2 = PercentEncoder.encode(value);
                    encodedList.add(encodedValue2);
                }
                paramMap.put(encodedKey2, encodedList);
            }
        }
        boolean oauthParamFoundInForm = false;
        if (formParams != null) {
            if (paramMap == null) {
                paramMap = new HashMap();
            }
            for (String k : formParams.keySet()) {
                if (OAuthConstants.isOAuthParam(k)) {
                    if (oauthParamFoundInHeader) {
                        throw new ValidationException("OAuth param already present in header. But found in form again: param = " + k);
                    }
                    oauthParamFoundInForm = true;
                }
                if ("oauth_signature".equals(k)) continue;
                encodedKey = PercentEncoder.encode(k);
                String[] values = formParams.get(k);
                ArrayList<String> encodedList2 = null;
                if (values != null) {
                    encodedList2 = new ArrayList<String>();
                    for (String v : values) {
                        encodedValue = PercentEncoder.encode(v);
                        encodedList2.add(encodedValue);
                    }
                }
                paramMap.put(encodedKey, encodedList2);
            }
        }
        if (queryParams != null) {
            if (paramMap == null) {
                paramMap = new HashMap();
            }
            for (String q : queryParams.keySet()) {
                if (OAuthConstants.isOAuthParam(q) && (oauthParamFoundInHeader || oauthParamFoundInForm)) {
                    throw new ValidationException("OAuth param already present in header/form. But found in query again: param = " + q);
                }
                if ("oauth_signature".equals(q)) continue;
                encodedKey = PercentEncoder.encode(q);
                encodedList = (ArrayList<String>)paramMap.get(encodedKey);
                String[] values = queryParams.get(q);
                if (values != null) {
                    if (encodedList == null) {
                        encodedList = new ArrayList();
                        paramMap.put(encodedKey, encodedList);
                    }
                    for (String v : values) {
                        encodedValue = PercentEncoder.encode(v);
                        encodedList.add(encodedValue);
                    }
                    continue;
                }
                if (encodedList != null) continue;
                paramMap.put(encodedKey, null);
            }
        }
        return paramMap;
    }

    protected Map<String, List<String>> percentEncodeRequestParams(Map<String, String> authHeader, Map<String, String[]> requestParams) throws MiniAuthException {
        String encodedKey;
        boolean oauthParamFoundInHeader = false;
        HashMap<String, List<String>> paramMap = null;
        if (authHeader != null) {
            paramMap = new HashMap<String, List<String>>();
            for (String h : authHeader.keySet()) {
                if (OAuthConstants.isOAuthParam(h)) {
                    oauthParamFoundInHeader = true;
                }
                if ("oauth_signature".equals(h) || "realm".equals(h)) continue;
                encodedKey = PercentEncoder.encode(h);
                String value = authHeader.get(h);
                ArrayList<String> encodedList = null;
                if (value != null) {
                    encodedList = new ArrayList<String>();
                    String encodedValue = PercentEncoder.encode(value);
                    encodedList.add(encodedValue);
                }
                paramMap.put(encodedKey, encodedList);
            }
        }
        if (requestParams != null) {
            if (paramMap == null) {
                paramMap = new HashMap();
            }
            for (String q : requestParams.keySet()) {
                if (OAuthConstants.isOAuthParam(q) && oauthParamFoundInHeader) {
                    throw new ValidationException("OAuth param already present in header/form. But found in query again: param = " + q);
                }
                if ("oauth_signature".equals(q)) continue;
                encodedKey = PercentEncoder.encode(q);
                ArrayList<String> encodedList = (ArrayList<String>)paramMap.get(encodedKey);
                String[] values = requestParams.get(q);
                if (values != null) {
                    if (encodedList == null) {
                        encodedList = new ArrayList<String>();
                        paramMap.put(encodedKey, encodedList);
                    }
                    for (String v : values) {
                        String encodedValue = PercentEncoder.encode(v);
                        encodedList.add(encodedValue);
                    }
                    continue;
                }
                if (encodedList != null) continue;
                paramMap.put(encodedKey, null);
            }
        }
        return paramMap;
    }
}

