/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.builder;

import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.builder.AuthStringBuilder;
import org.miniauth.core.AuthScheme;
import org.miniauth.oauth.common.OAuthParamMap;
import org.miniauth.oauth.signature.OAuthSignatureGenerator;
import org.miniauth.oauth.util.ParameterTransmissionUtil;

public class OAuthAuthStringBuilder
implements AuthStringBuilder {
    private static final Logger log = Logger.getLogger(OAuthAuthStringBuilder.class.getName());
    private OAuthSignatureGenerator oauthSignatureGenerator = null;

    public OAuthSignatureGenerator getOAuthSignatureGenerator() {
        if (this.oauthSignatureGenerator == null) {
            this.oauthSignatureGenerator = new OAuthSignatureGenerator();
        }
        return this.oauthSignatureGenerator;
    }

    public String generateAuthorizationString(String transmissionType, Map<String, String> authCredential, String httpMethod, URI baseURI, Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams) throws MiniAuthException {
        Map<String, Object> oauthParameters = this.getOAuthSignatureGenerator().generateOAuthParams(authCredential, httpMethod, baseURI, authHeader, formParams, queryParams);
        OAuthParamMap oauthParamMap = new OAuthParamMap(oauthParameters);
        if (!ParameterTransmissionUtil.isTransmissionTypeValid(transmissionType)) {
            transmissionType = ParameterTransmissionUtil.getDefaultTransmissionType();
        }
        String paramString = oauthParamMap.buildUrlEncodedParamString(transmissionType);
        String authString = null;
        authString = "header".equals(transmissionType) ? AuthScheme.getAuthorizationHeaderAuthScheme((String)"OAuth") + " " + paramString : paramString;
        if (log.isLoggable(Level.FINER)) {
            log.finer("authString = " + authString);
        }
        return authString;
    }

    public String generateAuthorizationString(String transmissionType, Map<String, String> authCredential, String httpMethod, URI baseURI, Map<String, String> authHeader, Map<String, String[]> requestParams) throws MiniAuthException {
        Map<String, Object> oauthParameters = this.getOAuthSignatureGenerator().generateOAuthParams(authCredential, httpMethod, baseURI, authHeader, requestParams);
        OAuthParamMap oauthParamMap = new OAuthParamMap(oauthParameters);
        if (!ParameterTransmissionUtil.isTransmissionTypeValid(transmissionType)) {
            transmissionType = ParameterTransmissionUtil.getDefaultTransmissionType();
        }
        String paramString = oauthParamMap.buildUrlEncodedParamString(transmissionType);
        String authString = null;
        authString = "header".equals(transmissionType) ? AuthScheme.getAuthorizationHeaderAuthScheme((String)"OAuth") + " " + paramString : paramString;
        if (log.isLoggable(Level.FINER)) {
            log.finer("authString = " + authString);
        }
        return authString;
    }
}

