/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.common;

import java.net.URI;
import java.util.Map;
import org.miniauth.MiniAuthException;
import org.miniauth.common.BaseURIInfo;
import org.miniauth.common.RequestBase;
import org.miniauth.oauth.common.OAuthIncomingRequest;

public final class OAuthIncomingRequestBuilder {
    private OAuthIncomingRequest incomingRequest;

    public OAuthIncomingRequestBuilder() {
        this.init();
    }

    public OAuthIncomingRequestBuilder init() {
        return this.init(null);
    }

    public OAuthIncomingRequestBuilder init(OAuthIncomingRequest incomingRequest) {
        this.incomingRequest = new OAuthIncomingRequest((RequestBase)incomingRequest);
        return this;
    }

    public OAuthIncomingRequestBuilder setHttpMethod(String httpMethod) throws MiniAuthException {
        this.incomingRequest.setHttpMethod(httpMethod);
        return this;
    }

    public OAuthIncomingRequestBuilder setBaseURI(URI baseURI) throws MiniAuthException {
        this.incomingRequest.setBaseURI(baseURI);
        return this;
    }

    public OAuthIncomingRequestBuilder setBaseURI(String baseUri) throws MiniAuthException {
        this.incomingRequest.setBaseURI(baseUri);
        return this;
    }

    public OAuthIncomingRequestBuilder setBaseURI(BaseURIInfo uriInfo) throws MiniAuthException {
        this.incomingRequest.setBaseURI(uriInfo);
        return this;
    }

    public OAuthIncomingRequestBuilder setAuthHeader(String authHeader) throws MiniAuthException {
        this.incomingRequest.setAuthHeader(authHeader);
        return this;
    }

    public OAuthIncomingRequestBuilder setAuthHeaderAuthorizationString(String authHeaderStr) throws MiniAuthException {
        this.incomingRequest.setAuthHeaderAuthorizationString(authHeaderStr);
        return this;
    }

    public OAuthIncomingRequestBuilder setAuthHeader(Map<String, String> authHeader) throws MiniAuthException {
        this.incomingRequest.setAuthHeader(authHeader);
        return this;
    }

    public OAuthIncomingRequestBuilder addAuthHeaderParam(String key, String value) throws MiniAuthException {
        this.incomingRequest.addAuthHeaderParam(key, value);
        return this;
    }

    public OAuthIncomingRequestBuilder setFormParams(String formBody) throws MiniAuthException {
        this.incomingRequest.setFormParams(formBody);
        return this;
    }

    public OAuthIncomingRequestBuilder setFormParams(Map<String, String[]> formParams) throws MiniAuthException {
        this.incomingRequest.setFormParams(formParams);
        return this;
    }

    public OAuthIncomingRequestBuilder addFormParams(Map<String, String[]> formParams) throws MiniAuthException {
        this.incomingRequest.addFormParams(formParams);
        return this;
    }

    public OAuthIncomingRequestBuilder addFormParam(String key, String value) throws MiniAuthException {
        this.incomingRequest.addFormParam(key, value);
        return this;
    }

    public OAuthIncomingRequestBuilder setQueryParams(String queryString) throws MiniAuthException {
        this.incomingRequest.setQueryParams(queryString);
        return this;
    }

    public OAuthIncomingRequestBuilder setQueryParams(Map<String, String[]> queryParams) throws MiniAuthException {
        this.incomingRequest.setQueryParams(queryParams);
        return this;
    }

    public OAuthIncomingRequestBuilder addQueryParams(Map<String, String[]> queryParams) throws MiniAuthException {
        this.incomingRequest.addQueryParams(queryParams);
        return this;
    }

    public OAuthIncomingRequestBuilder addQueryParam(String key, String value) throws MiniAuthException {
        this.incomingRequest.addQueryParam(key, value);
        return this;
    }

    public OAuthIncomingRequest build() throws MiniAuthException {
        this.incomingRequest.prepare();
        return this.incomingRequest;
    }
}

