/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.credential.AccessIdentity;
import org.miniauth.oauth.core.OAuthConstants;
import org.miniauth.oauth.core.SignatureMethod;
import org.miniauth.oauth.credential.OAuthAccessIdentity;
import org.miniauth.oauth.util.OAuthAuthorizationValueUtil;
import org.miniauth.oauth.util.ParameterTransmissionUtil;
import org.miniauth.util.ParamMapUtil;

public final class OAuthParamMap
implements Serializable {
    private static final Logger log = Logger.getLogger(OAuthParamMap.class.getName());
    private static final long serialVersionUID = 1L;
    private final Map<String, Object> paramMap = new HashMap<String, Object>();

    public OAuthParamMap() {
        this((OAuthParamMap)null);
    }

    public OAuthParamMap(OAuthParamMap oauthParamMap) {
        this(oauthParamMap != null ? oauthParamMap.toReadOnlyMap() : (Map)null);
    }

    public OAuthParamMap(OAuthParamMap oauthParamMap, boolean copyOAuthParamOnly) {
        this(oauthParamMap != null ? oauthParamMap.toReadOnlyMap() : (Map)null, copyOAuthParamOnly);
    }

    public OAuthParamMap(Map<String, ? extends Object> paramMap) {
        this(paramMap, true);
    }

    public OAuthParamMap(Map<String, ? extends Object> paramMap, boolean copyOAuthParamOnly) {
        this.updateParams(paramMap, copyOAuthParamOnly);
    }

    public void updateParams(OAuthParamMap oauthParamMap) {
        if (oauthParamMap != null) {
            this.updateParams(oauthParamMap.toReadOnlyMap());
        }
    }

    public void updateParams(OAuthParamMap oauthParamMap, boolean copyOAuthParamOnly) {
        if (oauthParamMap != null) {
            this.updateParams(oauthParamMap.toReadOnlyMap(), copyOAuthParamOnly);
        }
    }

    public void updateParams(Map<String, ? extends Object> paramMap) {
        this.updateParams(paramMap, true);
    }

    public void updateParams(Map<String, ? extends Object> paramMap, boolean copyOAuthParamOnly) {
        block10: {
            if (paramMap == null) break block10;
            if (copyOAuthParamOnly) {
                for (String p : OAuthConstants.getAllOAuthParams()) {
                    Object val = paramMap.get(p);
                    if (val == null) continue;
                    if (p.equals("oauth_timestamp") && val instanceof String) {
                        try {
                            Integer ts = Integer.valueOf((String)val);
                            this.paramMap.put(p, ts);
                        }
                        catch (Exception e) {
                            log.log(Level.INFO, "Invalid type for timestamp: " + val, e);
                        }
                        continue;
                    }
                    this.paramMap.put(p, val);
                }
            } else {
                for (String k : paramMap.keySet()) {
                    Object val = paramMap.get(k);
                    if (val == null) continue;
                    if (k.equals("oauth_timestamp") && val instanceof String) {
                        try {
                            Integer ts = Integer.valueOf((String)val);
                            this.paramMap.put(k, ts);
                        }
                        catch (Exception e) {
                            log.log(Level.INFO, "Invalid type for timestamp: " + val, e);
                        }
                        continue;
                    }
                    this.paramMap.put(k, val);
                }
            }
        }
    }

    public Map<String, Object> toReadOnlyMap() {
        return new HashMap<String, Object>(this.paramMap);
    }

    public boolean isEmpty() {
        return this.paramMap == null || this.paramMap.isEmpty();
    }

    public String getConsumerKey() {
        return (String)this.paramMap.get("oauth_consumer_key");
    }

    public void setConsumerKey(String consumerKey) {
        this.paramMap.put("oauth_consumer_key", consumerKey);
    }

    public String getToken() {
        return (String)this.paramMap.get("oauth_token");
    }

    public void setToken(String token) {
        this.paramMap.put("oauth_token", token);
    }

    public String getSignature() {
        return (String)this.paramMap.get("oauth_signature");
    }

    public void setSignature(String signature) {
        this.paramMap.put("oauth_signature", signature);
    }

    public String getSignatureMethod() {
        return (String)this.paramMap.get("oauth_signature_method");
    }

    public void setSignatureMethod(String signatureMethod) {
        this.paramMap.put("oauth_signature_method", signatureMethod);
    }

    public String getNonce() {
        return (String)this.paramMap.get("oauth_nonce");
    }

    public void setNonce(String nonce) {
        this.paramMap.put("oauth_nonce", nonce);
    }

    public int getTimestamp() {
        Integer timestamp = (Integer)this.paramMap.get("oauth_timestamp");
        if (timestamp != null) {
            return timestamp;
        }
        return 0;
    }

    public void setTimestamp(int timestamp) {
        this.paramMap.put("oauth_timestamp", timestamp);
    }

    public String getVersion() {
        return (String)this.paramMap.get("oauth_version");
    }

    public void setVersion(String version) {
        this.paramMap.put("oauth_version", version);
    }

    public boolean containsKey(Object key) {
        return this.paramMap.containsKey(key);
    }

    public Object get(Object key) {
        return this.paramMap.get(key);
    }

    public Object put(String key, Object value) {
        return this.paramMap.put(key, value);
    }

    public Object remove(Object key) {
        return this.paramMap.remove(key);
    }

    public Set<String> keySet() {
        return this.paramMap.keySet();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.paramMap.entrySet();
    }

    public boolean isSignatureSet() {
        String signature = this.getSignature();
        String signatureMethod = this.getSignatureMethod();
        return SignatureMethod.isValid(signatureMethod) && signature != null && !signature.isEmpty();
    }

    public AccessIdentity getAccessIdentity() {
        String consumerKey = this.getConsumerKey();
        String accessToken = this.getToken();
        OAuthAccessIdentity accessIdentity = new OAuthAccessIdentity(consumerKey, accessToken);
        return accessIdentity;
    }

    public void setAccessIdentity(AccessIdentity accessIdentity) {
        if (accessIdentity != null) {
            String consumerKey = accessIdentity.getConsumerKey();
            String token = accessIdentity.getAccessToken();
            if (consumerKey != null) {
                this.setConsumerKey(consumerKey);
            }
            if (token != null) {
                this.setToken(token);
            }
        }
    }

    public String buildUrlEncodedParamString() throws MiniAuthException {
        return this.buildUrlEncodedParamString(ParameterTransmissionUtil.getDefaultTransmissionType());
    }

    public String buildUrlEncodedParamString(String transmissionType) throws MiniAuthException {
        Map params = ParamMapUtil.convertObjectValueMapToStringValueMap(this.paramMap);
        String paramString = OAuthAuthorizationValueUtil.buildOAuthAuthorizationValueString(params, transmissionType);
        if (log.isLoggable(Level.FINER)) {
            log.finer("paramString = " + paramString);
        }
        return paramString;
    }

    public String toString() {
        return "OAuthParamMap [paramMap=" + this.paramMap + "]";
    }
}

