/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.common;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.credential.AccessIdentity;
import org.miniauth.oauth.common.OAuthIncomingRequest;
import org.miniauth.oauth.common.OAuthOutgoingRequest;
import org.miniauth.oauth.common.OAuthParamMap;
import org.miniauth.oauth.core.SignatureMethod;
import org.miniauth.oauth.nonce.NonceGenerator;
import org.miniauth.oauth.util.OAuthSignatureUtil;

public final class OAuthParamMapUtil {
    private static final Logger log = Logger.getLogger(OAuthParamMapUtil.class.getName());

    private OAuthParamMapUtil() {
    }

    public static OAuthParamMap buildOAuthParams(OAuthOutgoingRequest request) throws MiniAuthException {
        return OAuthParamMapUtil.buildOAuthParams(request, null);
    }

    public static OAuthParamMap buildOAuthParams(OAuthOutgoingRequest request, AccessIdentity accessIdentity) throws MiniAuthException {
        String signatureMethod;
        String version;
        OAuthParamMap oauthParamMap = null;
        oauthParamMap = request == null ? new OAuthParamMap() : new OAuthParamMap(OAuthSignatureUtil.getOAuthParams(request.getAuthHeader(), request.getFormParams(), request.getQueryParams()));
        if (accessIdentity != null) {
            oauthParamMap.setAccessIdentity(accessIdentity);
        }
        if ((version = oauthParamMap.getVersion()) == null || version.isEmpty()) {
            oauthParamMap.setVersion("1.0");
        }
        if ((signatureMethod = oauthParamMap.getSignatureMethod()) == null || signatureMethod.isEmpty()) {
            oauthParamMap.setSignatureMethod("HMAC-SHA1");
        }
        if (SignatureMethod.requiresNonceAndTimestamp(signatureMethod)) {
            String nonce;
            int timestamp = oauthParamMap.getTimestamp();
            if (timestamp <= 0) {
                timestamp = (int)(System.currentTimeMillis() / 1000L);
                oauthParamMap.setTimestamp(timestamp);
            }
            if ((nonce = oauthParamMap.getNonce()) == null || nonce.isEmpty()) {
                nonce = NonceGenerator.generateRandomNonce();
                oauthParamMap.setNonce(nonce);
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("oauthParamMap = " + oauthParamMap);
        }
        return oauthParamMap;
    }

    public static OAuthParamMap buildOAuthParams(OAuthIncomingRequest request) throws MiniAuthException {
        OAuthParamMap oauthParamMap = OAuthSignatureUtil.validateOAuthParams(request.getAuthHeader(), request.getFormParams(), request.getQueryParams(), true);
        if (log.isLoggable(Level.FINER)) {
            log.finer("oauthParamMap = " + oauthParamMap);
        }
        return oauthParamMap;
    }
}

