/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.core;

import java.util.HashSet;
import java.util.Set;

public final class OAuthConstants {
    public static final String PARAM_OAUTH_CONSUMER_KEY = "oauth_consumer_key";
    public static final String PARAM_OAUTH_TOKEN = "oauth_token";
    public static final String PARAM_OAUTH_SIGNATURE = "oauth_signature";
    public static final String PARAM_OAUTH_SIGNATURE_METHOD = "oauth_signature_method";
    public static final String PARAM_OAUTH_NONCE = "oauth_nonce";
    public static final String PARAM_OAUTH_TIMESTAMP = "oauth_timestamp";
    public static final String PARAM_OAUTH_VERSION = "oauth_version";
    public static final String PARAM_REALM = "realm";
    public static final String PARAM_OAUTH_CALLBACK = "oauth_callback";
    public static final String PARAM_OAUTH_TOKEN_VERIFIER = "oauth_verifier";
    public static final String OAUTH_VERSION_STRING = "1.0";
    private static final Set<String> sOAuthParams = new HashSet<String>();
    private static final Set<String> sAllOAuthParams;

    private OAuthConstants() {
    }

    public static boolean isOAuthParam(String param) {
        return sOAuthParams.contains(param);
    }

    public static Set<String> getOAuthParams() {
        return sOAuthParams;
    }

    public static Set<String> getAllOAuthParams() {
        return sAllOAuthParams;
    }

    static {
        sOAuthParams.add(PARAM_OAUTH_CONSUMER_KEY);
        sOAuthParams.add(PARAM_OAUTH_TOKEN);
        sOAuthParams.add(PARAM_OAUTH_SIGNATURE);
        sOAuthParams.add(PARAM_OAUTH_SIGNATURE_METHOD);
        sOAuthParams.add(PARAM_OAUTH_NONCE);
        sOAuthParams.add(PARAM_OAUTH_TIMESTAMP);
        sOAuthParams.add(PARAM_OAUTH_VERSION);
        sAllOAuthParams = new HashSet<String>(sOAuthParams);
        sAllOAuthParams.add(PARAM_REALM);
        sAllOAuthParams.add(PARAM_OAUTH_CALLBACK);
        sAllOAuthParams.add(PARAM_OAUTH_TOKEN_VERIFIER);
    }
}

