/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.core;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public final class SignatureMethod {
    private static final Logger log = Logger.getLogger(SignatureMethod.class.getName());
    public static final String HMAC_SHA1 = "HMAC-SHA1";
    public static final String RSA_SHA1 = "RSA-SHA1";
    public static final String PLAINTEXT = "PLAINTEXT";
    private static Map<String, String> algorithmName = new HashMap<String, String>();

    private SignatureMethod() {
    }

    public static String getAlgorithmName(String sigMethod) {
        return algorithmName.get(sigMethod);
    }

    public static boolean isValid(String sigMethod) {
        return algorithmName.containsKey(sigMethod);
    }

    public static boolean requiresNonceAndTimestamp(String sigMethod) {
        if (algorithmName.containsKey(sigMethod)) {
            return !sigMethod.equals(PLAINTEXT);
        }
        return false;
    }

    static {
        algorithmName.put(HMAC_SHA1, "HmacSHA1");
        algorithmName.put(RSA_SHA1, "SHA1withRSA");
        algorithmName.put(PLAINTEXT, null);
    }
}

