/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.credential;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.miniauth.credential.AccessCredential;
import org.miniauth.credential.AccessIdentity;
import org.miniauth.credential.ConsumerCredential;
import org.miniauth.credential.CredentialPair;
import org.miniauth.credential.TokenCredential;
import org.miniauth.oauth.credential.OAuthAccessCredential;
import org.miniauth.oauth.credential.OAuthAccessIdentity;
import org.miniauth.oauth.credential.OAuthConsumerCredential;
import org.miniauth.oauth.credential.OAuthTokenCredential;

public class OAuthCredentialPair
implements CredentialPair,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ConsumerCredential consumerCredential;
    private final TokenCredential tokenCredential;
    private volatile AccessIdentity accessIdentity = null;
    private volatile AccessCredential accessCredential = null;

    public OAuthCredentialPair(ConsumerCredential consumerCredential, TokenCredential tokenCredential) {
        this.consumerCredential = consumerCredential;
        this.tokenCredential = tokenCredential;
    }

    public OAuthCredentialPair(Map<String, String> authCredential) {
        this(authCredential != null ? authCredential.get("consumerKey") : null, authCredential != null ? authCredential.get("consumerSecret") : null, authCredential != null ? authCredential.get("accessToken") : null, authCredential != null ? authCredential.get("tokenSecret") : null);
    }

    public OAuthCredentialPair(String consumerKey, String consumerSecret, String accessToken, String tokenSecret) {
        this(new OAuthConsumerCredential(consumerKey, consumerSecret), new OAuthTokenCredential(accessToken, tokenSecret));
    }

    public Map<String, String> toReadOnlyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.consumerCredential != null) {
            map.put("consumerKey", this.consumerCredential.getConsumerKey());
            map.put("consumerSecret", this.consumerCredential.getConsumerSecret());
        }
        if (this.tokenCredential != null) {
            map.put("accessToken", this.tokenCredential.getAccessToken());
            map.put("tokenSecret", this.tokenCredential.getTokenSecret());
        }
        return map;
    }

    public String getConsumerKey() {
        if (this.consumerCredential != null) {
            return this.consumerCredential.getConsumerKey();
        }
        return null;
    }

    public String getConsumerSecret() {
        if (this.consumerCredential != null) {
            return this.consumerCredential.getConsumerSecret();
        }
        return null;
    }

    public String getAccessToken() {
        if (this.tokenCredential != null) {
            return this.tokenCredential.getAccessToken();
        }
        return null;
    }

    public String getTokenSecret() {
        if (this.tokenCredential != null) {
            return this.tokenCredential.getTokenSecret();
        }
        return null;
    }

    public ConsumerCredential getConsumerCredential() {
        return this.consumerCredential;
    }

    public TokenCredential getTokenCredential() {
        return this.tokenCredential;
    }

    public AccessIdentity getAccessIdentity() {
        if (this.accessIdentity == null) {
            this.accessIdentity = new OAuthAccessIdentity(this.getConsumerKey(), this.getAccessToken());
        }
        return this.accessIdentity;
    }

    public AccessCredential getAccessCredential() {
        if (this.accessCredential == null) {
            this.accessCredential = new OAuthAccessCredential(this.getConsumerKey(), this.getAccessToken());
        }
        return this.accessCredential;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.consumerCredential == null ? 0 : this.consumerCredential.hashCode());
        result = 31 * result + (this.tokenCredential == null ? 0 : this.tokenCredential.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuthCredentialPair other = (OAuthCredentialPair)obj;
        if (this.consumerCredential == null ? other.consumerCredential != null : !this.consumerCredential.equals(other.consumerCredential)) {
            return false;
        }
        return !(this.tokenCredential == null ? other.tokenCredential != null : !this.tokenCredential.equals(other.tokenCredential));
    }

    public String toString() {
        return "OAuthCredentialPair [consumerCredential=" + this.consumerCredential + ", tokenCredential=" + this.tokenCredential + ", accessIdentity=" + this.accessIdentity + ", accessCredential=" + this.accessCredential + "]";
    }
}

