/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.credential.mapper;

import java.io.Serializable;
import java.util.logging.Logger;
import org.miniauth.credential.AccessCredential;
import org.miniauth.credential.AccessIdentity;
import org.miniauth.exception.CredentialStoreException;
import org.miniauth.oauth.credential.OAuthAccessCredential;
import org.miniauth.oauth.credential.mapper.DynamicOAuthCredentialMapper;

public abstract class AbstractOAuthCredentialMapper
implements DynamicOAuthCredentialMapper,
Serializable {
    private static final Logger log = Logger.getLogger(AbstractOAuthCredentialMapper.class.getName());
    private static final long serialVersionUID = 1L;
    protected static final String CONSUMER_CREDENTIAL = "consumerCredential";
    protected static final String TOKEN_CREDENTIAL = "tokenCredential";

    public AbstractOAuthCredentialMapper() {
        this.init();
    }

    protected void init() {
    }

    @Override
    public String getConsumerSecret(String consumerKey) throws CredentialStoreException {
        return this.getCredentialSecret(CONSUMER_CREDENTIAL, consumerKey);
    }

    @Override
    public String putConsumerSecret(String consumerKey, String consumerSecret) throws CredentialStoreException {
        return this.putCredentialSecret(CONSUMER_CREDENTIAL, consumerKey, consumerSecret);
    }

    @Override
    public String getTokenSecret(String accessToken) throws CredentialStoreException {
        return this.getCredentialSecret(TOKEN_CREDENTIAL, accessToken);
    }

    @Override
    public String putTokenSecret(String accessToken, String tokenSecret) throws CredentialStoreException {
        return this.putCredentialSecret(TOKEN_CREDENTIAL, accessToken, tokenSecret);
    }

    @Override
    public AccessCredential getAccesssCredential(AccessIdentity accessIdentity) throws CredentialStoreException {
        if (accessIdentity == null) {
            return null;
        }
        String consumerKey = accessIdentity.getConsumerKey();
        String accessToken = accessIdentity.getAccessToken();
        String consumerSecret = this.getConsumerSecret(consumerKey);
        String tokenSecret = this.getTokenSecret(accessToken);
        return new OAuthAccessCredential(consumerSecret, tokenSecret);
    }

    @Override
    public AccessCredential putAccesssCredential(AccessIdentity accessIdentity, AccessCredential accessCredential) throws CredentialStoreException {
        if (accessIdentity == null || accessCredential == null) {
            return null;
        }
        String consumerKey = accessIdentity.getConsumerKey();
        String accessToken = accessIdentity.getAccessToken();
        String consumerSecret = accessCredential.getConsumerSecret();
        String tokenSecret = accessCredential.getTokenSecret();
        String oldConsumerSecret = this.putConsumerSecret(consumerKey, consumerSecret);
        String oldTokenSecret = this.putTokenSecret(accessToken, tokenSecret);
        return new OAuthAccessCredential(oldConsumerSecret, oldTokenSecret);
    }
}

