/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.credential.mapper;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.miniauth.exception.CredentialStoreException;
import org.miniauth.oauth.credential.mapper.AbstractOAuthCredentialMapper;
import org.miniauth.oauth.credential.mapper.DynamicOAuthCredentialMapper;

public final class OAuthLocalCredentialMapper
extends AbstractOAuthCredentialMapper
implements DynamicOAuthCredentialMapper {
    private static final Logger log = Logger.getLogger(OAuthLocalCredentialMapper.class.getName());
    private static final long serialVersionUID = 1L;
    private final Map<String, Map<String, String>> superRegistry = new HashMap<String, Map<String, String>>();

    private OAuthLocalCredentialMapper() {
    }

    @Override
    protected void init() {
    }

    public static OAuthLocalCredentialMapper getInstance() {
        return OAuthLocalCredentialMapperHolder.INSTANCE;
    }

    public String getCredentialSecret(String credentialType, String credentialKey) throws CredentialStoreException {
        if (!this.superRegistry.containsKey(credentialType)) {
            return null;
        }
        Map<String, String> credentialRegistry = this.superRegistry.get(credentialType);
        return credentialRegistry.get(credentialKey);
    }

    public String putCredentialSecret(String credentialType, String credentialKey, String credentialSecret) throws CredentialStoreException {
        Map<Object, Object> credentialRegistry = null;
        if (!this.superRegistry.containsKey(credentialType)) {
            credentialRegistry = new HashMap();
            this.superRegistry.put(credentialType, credentialRegistry);
        } else {
            credentialRegistry = this.superRegistry.get(credentialType);
        }
        return credentialRegistry.put(credentialKey, credentialSecret);
    }

    private static final class OAuthLocalCredentialMapperHolder {
        private static final OAuthLocalCredentialMapper INSTANCE = new OAuthLocalCredentialMapper();

        private OAuthLocalCredentialMapperHolder() {
        }
    }
}

