/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.nonce;

import java.math.BigInteger;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NonceGenerator {
    private static final Logger log = Logger.getLogger(NonceGenerator.class.getName());
    private static Random sRrandom = new Random(System.currentTimeMillis());

    private NonceGenerator() {
    }

    public static String generateRandomNonce() {
        return NonceGenerator.generateRandomNonce(32);
    }

    public static String generateRandomNonce(int numBits) {
        BigInteger big = new BigInteger(numBits, sRrandom);
        String nonce = big.toString();
        if (log.isLoggable(Level.FINER)) {
            log.finer("Nonce generated = " + nonce);
        }
        return nonce;
    }
}

