/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.service;

import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.common.IncomingRequest;
import org.miniauth.credential.AccessCredential;
import org.miniauth.exception.InvalidInputException;
import org.miniauth.exception.InvalidStateException;
import org.miniauth.exception.UnauthorizedException;
import org.miniauth.oauth.common.OAuthIncomingRequest;
import org.miniauth.oauth.signature.OAuthSignatureVerifier;
import org.miniauth.service.RequestVerifier;
import org.miniauth.signature.SignatureVerifier;

public class OAuthRequestVerifier
implements RequestVerifier,
Serializable {
    private static final Logger log = Logger.getLogger(OAuthRequestVerifier.class.getName());
    private static final long serialVersionUID = 1L;
    private SignatureVerifier signatureVerifier = new OAuthSignatureVerifier();

    private OAuthRequestVerifier() {
    }

    public static OAuthRequestVerifier getInstance() {
        return OAuthRequestVerifierHolder.INSTANCE;
    }

    public boolean verify(AccessCredential credential, IncomingRequest request) throws MiniAuthException {
        if (request == null) {
            throw new InvalidInputException("IncomingRequest is null.");
        }
        if (!request.isReady()) {
            throw new InvalidStateException("IncomingRequest is not ready for verification.");
        }
        if (!request.isEndorsed()) {
            throw new UnauthorizedException("IncomingRequest is not endorsed.");
        }
        OAuthIncomingRequest oauthRequest = (OAuthIncomingRequest)request;
        Map authCredential = null;
        if (credential != null) {
            authCredential = credential.toReadOnlyMap();
        }
        boolean verified = this.signatureVerifier.verify(authCredential, oauthRequest.getHttpMethod(), oauthRequest.getBaseURI(), oauthRequest.getAuthHeader(), oauthRequest.getFormParams(), oauthRequest.getQueryParams());
        if (log.isLoggable(Level.FINE)) {
            log.fine("verified = " + verified);
        }
        return verified;
    }

    private static final class OAuthRequestVerifierHolder {
        private static final OAuthRequestVerifier INSTANCE = new OAuthRequestVerifier();

        private OAuthRequestVerifierHolder() {
        }
    }
}

