/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.service;

import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.common.IncomingRequest;
import org.miniauth.credential.AccessCredential;
import org.miniauth.credential.AccessIdentity;
import org.miniauth.exception.InvalidCredentialException;
import org.miniauth.oauth.common.OAuthIncomingRequest;
import org.miniauth.oauth.credential.mapper.OAuthCredentialMapper;
import org.miniauth.oauth.service.OAuthCredentialService;
import org.miniauth.oauth.service.OAuthRequestVerifier;
import org.miniauth.service.VerifierService;

public class OAuthVerifierService
extends OAuthCredentialService
implements VerifierService {
    private static final Logger log = Logger.getLogger(OAuthVerifierService.class.getName());
    private static final long serialVersionUID = 1L;

    public OAuthVerifierService(OAuthCredentialMapper credentialMapper) {
        super(credentialMapper);
    }

    public boolean verify(IncomingRequest request) throws MiniAuthException {
        AccessIdentity accessIdentity = ((OAuthIncomingRequest)request).getAccessIdentity();
        AccessCredential credential = this.getOAuthCredentialMapper().getAccesssCredential(accessIdentity);
        if (credential == null || credential.getTokenSecret() == null) {
            throw new InvalidCredentialException("AccessCredential not found.");
        }
        return OAuthRequestVerifier.getInstance().verify(credential, request);
    }
}

