/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.signature;

import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.common.BaseURIInfo;
import org.miniauth.exception.AuthSignatureException;
import org.miniauth.oauth.common.OAuthParamMap;
import org.miniauth.oauth.core.SignatureMethod;
import org.miniauth.oauth.credential.OAuthAccessCredential;
import org.miniauth.oauth.crypto.OAuthSignatureAlgorithm;
import org.miniauth.oauth.crypto.OAuthSignatureAlgorithmFactory;
import org.miniauth.oauth.signature.OAuthSignatureBase;
import org.miniauth.oauth.util.OAuthSignatureUtil;
import org.miniauth.signature.SignatureGenerator;

public class OAuthSignatureGenerator
extends OAuthSignatureBase
implements SignatureGenerator {
    private static final Logger log = Logger.getLogger(OAuthSignatureGenerator.class.getName());
    private static final long serialVersionUID = 1L;

    public String generate(Map<String, String> authCredential, String httpMethod, URI baseUri, Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams) throws MiniAuthException {
        Map<String, String[]> requestParams = OAuthSignatureUtil.mergeRequestParameters(formParams, queryParams);
        return this.generate(authCredential, httpMethod, baseUri, authHeader, requestParams);
    }

    public String generate(Map<String, String> authCredential, String httpMethod, URI baseUri, Map<String, String> authHeader, Map<String, String[]> requestParams) throws MiniAuthException {
        String signatureMethod = OAuthSignatureUtil.getOAuthSignatureMethod(authHeader, requestParams);
        if (!SignatureMethod.isValid(signatureMethod)) {
            throw new AuthSignatureException("Invalid signature method: " + signatureMethod);
        }
        OAuthAccessCredential accessCredential = null;
        if (authCredential != null) {
            String consumerSecret = null;
            if (authCredential.containsKey("consumerSecret")) {
                consumerSecret = authCredential.get("consumerSecret");
            }
            String tokenSecret = null;
            if (authCredential.containsKey("tokenSecret")) {
                tokenSecret = authCredential.get("tokenSecret");
            }
            accessCredential = new OAuthAccessCredential(consumerSecret, tokenSecret);
        }
        OAuthSignatureAlgorithm oauthSignatureAlgorithm = OAuthSignatureAlgorithmFactory.getInstance().getOAuthSignatureAlgorithm(signatureMethod);
        String signature = null;
        if ("PLAINTEXT".equals(signatureMethod)) {
            signature = oauthSignatureAlgorithm.generate(null, accessCredential);
        } else {
            BaseURIInfo uriInfo = new BaseURIInfo(baseUri);
            String signatureBaseString = this.buildSignatureBaseString(httpMethod, uriInfo, authHeader, requestParams);
            signature = oauthSignatureAlgorithm.generate(signatureBaseString, accessCredential);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("signature = " + signature);
        }
        return signature;
    }

    public Map<String, Object> generateOAuthParams(Map<String, String> authCredential, String httpMethod, URI baseUri, Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams) throws MiniAuthException {
        OAuthParamMap oAuthParamMap = this.generateOAuthParamMap(authCredential, httpMethod, baseUri, authHeader, formParams, queryParams);
        return oAuthParamMap.toReadOnlyMap();
    }

    public OAuthParamMap generateOAuthParamMap(Map<String, String> authCredential, String httpMethod, URI baseUri, Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams) throws MiniAuthException {
        Map<String, String[]> requestParams = OAuthSignatureUtil.mergeRequestParameters(formParams, queryParams);
        return this.generateOAuthParamMap(authCredential, httpMethod, baseUri, authHeader, requestParams);
    }

    public Map<String, Object> generateOAuthParams(Map<String, String> authCredential, String httpMethod, URI baseUri, Map<String, String> authHeader, Map<String, String[]> requestParams) throws MiniAuthException {
        OAuthParamMap oAuthParamMap = this.generateOAuthParamMap(authCredential, httpMethod, baseUri, authHeader, requestParams);
        return oAuthParamMap.toReadOnlyMap();
    }

    public OAuthParamMap generateOAuthParamMap(Map<String, String> authCredential, String httpMethod, URI baseUri, Map<String, String> authHeader, Map<String, String[]> requestParams) throws MiniAuthException {
        OAuthAccessCredential accessCredential = null;
        if (authCredential != null) {
            String consumerSecret = null;
            if (authCredential.containsKey("consumerSecret")) {
                consumerSecret = authCredential.get("consumerSecret");
            }
            String tokenSecret = null;
            if (authCredential.containsKey("tokenSecret")) {
                tokenSecret = authCredential.get("tokenSecret");
            }
            accessCredential = new OAuthAccessCredential(consumerSecret, tokenSecret);
        }
        String signatureMethod = OAuthSignatureUtil.getOAuthSignatureMethod(authHeader, requestParams);
        OAuthSignatureAlgorithm oauthSignatureAlgorithm = OAuthSignatureAlgorithmFactory.getInstance().getOAuthSignatureAlgorithm(signatureMethod);
        OAuthParamMap oAuthParamMap = new OAuthParamMap();
        if ("PLAINTEXT".equals(signatureMethod)) {
            oAuthParamMap = oauthSignatureAlgorithm.generateOAuthParamMap(null, accessCredential, authHeader, requestParams);
        } else {
            BaseURIInfo uriInfo = new BaseURIInfo(baseUri);
            String signatureBaseString = this.buildSignatureBaseString(httpMethod, uriInfo, authHeader, requestParams);
            oAuthParamMap = oauthSignatureAlgorithm.generateOAuthParamMap(signatureBaseString, accessCredential, authHeader, requestParams);
        }
        return oAuthParamMap;
    }
}

