/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.miniauth.exception.InternalErrorException;
import org.miniauth.oauth.util.ParameterTransmissionUtil;

public final class OAuthAuthorizationValueUtil {
    private static final Logger log = Logger.getLogger(OAuthAuthorizationValueUtil.class.getName());

    private OAuthAuthorizationValueUtil() {
    }

    public static String buildOAuthAuthorizationValueString(Map<String, String> params) throws InternalErrorException {
        return OAuthAuthorizationValueUtil.buildOAuthAuthorizationValueString(params, ParameterTransmissionUtil.getDefaultTransmissionType());
    }

    public static String buildOAuthAuthorizationValueString(Map<String, String> params, String transmissionType) throws InternalErrorException {
        if (params == null) {
            return null;
        }
        String separator = "&";
        if ("header".equals(transmissionType)) {
            separator = ",";
        }
        StringBuilder sb = new StringBuilder();
        try {
            Iterator<String> it = params.keySet().iterator();
            while (it.hasNext()) {
                String k = it.next();
                String encKey = URLEncoder.encode(k, "UTF-8");
                String v = params.get(k);
                sb.append(encKey).append("=\"");
                if (v != null && !v.isEmpty()) {
                    String encVal = URLEncoder.encode(v, "UTF-8");
                    sb.append(encVal);
                }
                sb.append("\"");
                if (!it.hasNext()) continue;
                sb.append(separator);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalErrorException("URL encoding error.", (Throwable)e);
        }
        return sb.toString();
    }
}

