/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth2.builder;

import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.builder.AuthStringBuilder;
import org.miniauth.core.AuthScheme;
import org.miniauth.exception.InvalidCredentialException;

public class OAuth2AuthStringBuilder
implements AuthStringBuilder {
    private static final Logger log = Logger.getLogger(OAuth2AuthStringBuilder.class.getName());

    public String generateAuthorizationString(String transmissionType, Map<String, String> authCredential, String httpMethod, URI baseURI, Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams) throws MiniAuthException {
        return this.generateAuthorizationString(transmissionType, authCredential, httpMethod, baseURI, authHeader, null);
    }

    public String generateAuthorizationString(String transmissionType, Map<String, String> authCredential, String httpMethod, URI baseURI, Map<String, String> authHeader, Map<String, String[]> requestParams) throws MiniAuthException {
        String accessToken = null;
        if (authCredential == null || !authCredential.containsKey("accessToken")) {
            throw new InvalidCredentialException("Access token is not provided.");
        }
        accessToken = authCredential.get("accessToken");
        String authString = AuthScheme.getAuthorizationHeaderAuthScheme((String)"OAuth2") + " " + accessToken;
        if (log.isLoggable(Level.FINER)) {
            log.finer("authString = " + authString);
        }
        return authString;
    }
}

