/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.web.oauth;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.miniauth.MiniAuthException;
import org.miniauth.common.IncomingRequest;
import org.miniauth.exception.InvalidInputException;
import org.miniauth.oauth.common.OAuthIncomingRequest;
import org.miniauth.oauth.common.OAuthIncomingRequestBuilder;
import org.miniauth.oauth.credential.mapper.AbstractOAuthCredentialMapper;
import org.miniauth.oauth.credential.mapper.OAuthCredentialMapper;
import org.miniauth.oauth.service.OAuthVerifierService;
import org.miniauth.web.ProviderAuthHandler;
import org.miniauth.web.oauth.OAuthAuthHandler;
import org.miniauth.web.oauth.util.OAuthServletRequestUtil;
import org.miniauth.web.util.ServletRequestUtil;

public class OAuthProviderAuthHandler
extends OAuthAuthHandler
implements ProviderAuthHandler {
    private static final Logger log = Logger.getLogger(OAuthProviderAuthHandler.class.getName());
    private final OAuthVerifierService verifierService = new OAuthVerifierService(this.getOAuthCredentialMapper());

    public OAuthProviderAuthHandler(AbstractOAuthCredentialMapper credentialMapper) {
        super((OAuthCredentialMapper)credentialMapper);
    }

    @Override
    public boolean verifyRequest(HttpServletRequest request) throws MiniAuthException, IOException {
        String httpMethod = request.getMethod();
        String requestUrl = null;
        URI baseURI = null;
        try {
            requestUrl = request.getRequestURL().toString();
            baseURI = new URI(requestUrl);
        }
        catch (Exception e) {
            throw new InvalidInputException("Invalid requestUrl = " + requestUrl, (Throwable)e);
        }
        Map<String, String> authHeader = OAuthServletRequestUtil.getAuthParams(request);
        Map<String, String[]> formParams = ServletRequestUtil.getFormParams(request);
        Map<String, String[]> queryParams = ServletRequestUtil.getQueryParams(request);
        OAuthIncomingRequest incomingRequest = new OAuthIncomingRequestBuilder().setHttpMethod(httpMethod).setBaseURI(baseURI).setAuthHeader(authHeader).setFormParams(formParams).setQueryParams(queryParams).build();
        boolean verified = this.verifierService.verify((IncomingRequest)incomingRequest);
        if (log.isLoggable(Level.FINE)) {
            log.fine("verified = " + verified);
        }
        return verified;
    }
}

