/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.web.oauth;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.common.BaseURIInfo;
import org.miniauth.common.OutgoingRequest;
import org.miniauth.credential.AccessIdentity;
import org.miniauth.exception.InternalErrorException;
import org.miniauth.exception.InvalidInputException;
import org.miniauth.exception.InvalidStateException;
import org.miniauth.oauth.common.OAuthOutgoingRequest;
import org.miniauth.oauth.common.OAuthOutgoingRequestBuilder;
import org.miniauth.oauth.credential.mapper.OAuthCredentialMapper;
import org.miniauth.oauth.credential.mapper.OAuthTokenCredentialMapper;
import org.miniauth.oauth.service.OAuthEndorserService;
import org.miniauth.web.URLConnectionAuthHandler;
import org.miniauth.web.oauth.OAuthAuthHandler;
import org.miniauth.web.oauth.util.OAuthURLConnectionUtil;
import org.miniauth.web.util.URLConnectionUtil;

public class OAuthURLConnectionAuthHandler
extends OAuthAuthHandler
implements URLConnectionAuthHandler {
    private static final Logger log = Logger.getLogger(OAuthURLConnectionAuthHandler.class.getName());
    private final OAuthEndorserService endorserService = new OAuthEndorserService(this.getOAuthTokenCredentialMapper());

    public OAuthURLConnectionAuthHandler(OAuthTokenCredentialMapper credentialMapper) {
        super((OAuthCredentialMapper)credentialMapper);
    }

    public OAuthTokenCredentialMapper getOAuthTokenCredentialMapper() {
        return (OAuthTokenCredentialMapper)this.getOAuthCredentialMapper();
    }

    private boolean isEndorsed(HttpURLConnection conn) throws MiniAuthException, IOException {
        return OAuthURLConnectionUtil.isOAuthSignaturePresent(conn);
    }

    @Override
    public boolean endorseRequest(String accessToken, HttpURLConnection conn) throws MiniAuthException, IOException {
        String transmissionType;
        AccessIdentity accessIdentity = this.getOAuthTokenCredentialMapper().getAccessIdentity(accessToken);
        String httpMethod = conn.getRequestMethod();
        URL url = conn.getURL();
        if (url == null) {
            throw new InvalidStateException("Request URL is not set.");
        }
        URI baseURI = BaseURIInfo.createBaseURI((URL)url);
        Map<String, String> authHeader = OAuthURLConnectionUtil.getAuthParams(conn);
        Map formParams = null;
        Map<String, String[]> queryParams = URLConnectionUtil.getQueryParams(conn);
        OAuthOutgoingRequest outgoingRequest = new OAuthOutgoingRequestBuilder().setHttpMethod(httpMethod).setBaseURI(baseURI).setAuthHeader(authHeader).setFormParams(formParams).setQueryParams(queryParams).setAccessIdentity(accessIdentity).build();
        boolean endorsed = this.endorserService.endorse((OutgoingRequest)outgoingRequest);
        if (!endorsed) {
            throw new InternalErrorException("Failed to endorse the request due to unknown errors.");
        }
        switch (transmissionType = outgoingRequest.getAuthParamTransmissionType()) {
            case "header": {
                String authHeaderStr = outgoingRequest.getAuthHeaderAuthorizationString();
                conn.setRequestProperty("Authorization", authHeaderStr);
                break;
            }
            case "query": {
                throw new InvalidInputException("Query string cannot be used to include the OAuth signature. ");
            }
            case "form": {
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                String formBody = outgoingRequest.getFormParamString();
                OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
                out.write(formBody);
                break;
            }
            default: {
                throw new InternalErrorException("Not supported/implemented transmissionType: " + transmissionType);
            }
        }
        return endorsed;
    }
}

