/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.web.oauth.util;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public final class OAuthParamUtil {
    private static final Logger log = Logger.getLogger(OAuthParamUtil.class.getName());

    private OAuthParamUtil() {
    }

    public static Map<String, String> buildNewOAuthHeaderMap(Map<String, String> authCredential) {
        HashMap<String, String> authHeader = new HashMap<String, String>();
        authHeader.put("oauth_version", "1.0");
        authHeader.put("oauth_signature_method", "HMAC-SHA1");
        if (authCredential != null) {
            if (authCredential.containsKey("consumerKey")) {
                authHeader.put("oauth_consumer_key", authCredential.get("consumerKey"));
            }
            if (authCredential.containsKey("accessToken")) {
                authHeader.put("oauth_token", authCredential.get("accessToken"));
            }
        }
        return authHeader;
    }
}

