/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.web.filter;

import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.miniauth.MiniAuthException;
import org.miniauth.oauth.credential.mapper.AbstractOAuthCredentialMapper;
import org.miniauth.web.ProviderAuthHandler;
import org.miniauth.web.filter.ProviderAuthFilter;
import org.miniauth.web.oauth.OAuthProviderAuthHandler;

public class OAuthProviderAuthFilter
extends ProviderAuthFilter
implements Filter {
    private static final Logger log = Logger.getLogger(OAuthProviderAuthFilter.class.getName());
    AbstractOAuthCredentialMapper credentialMapper = null;
    private ProviderAuthHandler providerAuthHandler = null;

    private ProviderAuthHandler getProviderAuthHandler() {
        if (this.providerAuthHandler == null) {
            this.providerAuthHandler = new OAuthProviderAuthHandler(this.credentialMapper);
        }
        return this.providerAuthHandler;
    }

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        super.setAuthScheme("OAuth");
        this.credentialMapper = null;
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        boolean verified = false;
        try {
            verified = this.getProviderAuthHandler().verifyRequest((HttpServletRequest)req);
        }
        catch (MiniAuthException e) {
            throw new ServletException("Invalid auth.", (Throwable)e);
        }
        catch (Exception e) {
            throw new ServletException("Unknown error.", (Throwable)e);
        }
        if (!verified) {
            // empty if block
        }
        chain.doFilter(req, res);
    }
}

