/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.web.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.miniauth.MiniAuthException;
import org.miniauth.util.FormParamUtil;
import org.miniauth.util.QueryParamUtil;

public final class ServletRequestUtil {
    private static final Logger log = Logger.getLogger(ServletRequestUtil.class.getName());

    private ServletRequestUtil() {
    }

    public static Map<String, String[]> getQueryParams(HttpServletRequest request) throws MiniAuthException {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return null;
        }
        Map queryParams = QueryParamUtil.parseQueryParams((String)queryString);
        if (log.isLoggable(Level.FINER)) {
            log.finer("queryParams = " + queryParams);
        }
        return queryParams;
    }

    public static Map<String, String[]> getFormParams(HttpServletRequest request) throws MiniAuthException, IOException {
        String contentType = request.getContentType();
        if (contentType == null || !contentType.equals("application/x-www-form-urlencoded")) {
            return null;
        }
        String formBody = ServletRequestUtil.readFormBody(request);
        Map formParams = FormParamUtil.parseUrlEncodedFormParams((String)contentType, (String)formBody);
        if (log.isLoggable(Level.FINER)) {
            log.finer("formParams = " + formParams);
        }
        return formParams;
    }

    public static Map<String, String[]> getRequestParams(HttpServletRequest request) throws MiniAuthException {
        HashMap<String, String[]> requestParams = new HashMap<String, String[]>(request.getParameterMap());
        if (log.isLoggable(Level.FINER)) {
            log.finer("requestParams = " + requestParams);
        }
        return requestParams;
    }

    public static String readFormBody(HttpServletRequest request) throws IOException {
        StringBuilder sb = new StringBuilder();
        ServletInputStream inputStream = request.getInputStream();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));){
            if (inputStream != null) {
                char[] charBuffer = new char[512];
                int bytesRead = -1;
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    sb.append(charBuffer, 0, bytesRead);
                }
            }
        }
        String formBody = sb.toString();
        if (log.isLoggable(Level.FINER)) {
            log.finer("formBody = " + formBody);
        }
        return formBody;
    }

    public static Map<String, String[]> parseServletRequest(ServletRequest request) {
        Map params = request.getParameterMap();
        String contentType = request.getContentType();
        return params;
    }
}

