/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.web.oauth;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.common.BaseURIInfo;
import org.miniauth.common.OutgoingRequest;
import org.miniauth.exception.InternalErrorException;
import org.miniauth.exception.InvalidInputException;
import org.miniauth.exception.InvalidStateException;
import org.miniauth.oauth.common.OAuthOutgoingRequest;
import org.miniauth.oauth.common.OAuthOutgoingRequestBuilder;
import org.miniauth.oauth.credential.mapper.OAuthConsumerCredentialMapper;
import org.miniauth.oauth.credential.mapper.OAuthCredentialMapper;
import org.miniauth.oauth.credential.mapper.OAuthSingleConsumerCredentialMapper;
import org.miniauth.oauth.service.OAuthSingleConsumerEndorserService;
import org.miniauth.web.SingleConsumerURLConnectionAuthHandler;
import org.miniauth.web.oauth.OAuthAuthHandler;
import org.miniauth.web.oauth.util.OAuthURLConnectionUtil;
import org.miniauth.web.util.URLConnectionUtil;

public class OAuthSingleConsumerURLConnectionAuthHandler
extends OAuthAuthHandler
implements SingleConsumerURLConnectionAuthHandler {
    private static final Logger log = Logger.getLogger(OAuthSingleConsumerURLConnectionAuthHandler.class.getName());
    private static final long serialVersionUID = 1L;
    private final OAuthSingleConsumerEndorserService endorserService;

    public OAuthSingleConsumerURLConnectionAuthHandler(String consumerKey, String consumerSecret) {
        this(new OAuthSingleConsumerCredentialMapper(consumerKey, consumerSecret));
    }

    public OAuthSingleConsumerURLConnectionAuthHandler(OAuthSingleConsumerCredentialMapper credentialMapper) {
        super((OAuthCredentialMapper)credentialMapper);
        this.endorserService = new OAuthSingleConsumerEndorserService(credentialMapper);
    }

    public OAuthConsumerCredentialMapper getOAuthConsumerCredentialMapper() {
        return (OAuthConsumerCredentialMapper)this.getOAuthCredentialMapper();
    }

    public OAuthSingleConsumerCredentialMapper getOAuthSingleConsumerCredentialMapper() {
        return (OAuthSingleConsumerCredentialMapper)this.getOAuthCredentialMapper();
    }

    private boolean isEndorsed(HttpURLConnection conn) throws MiniAuthException, IOException {
        return OAuthURLConnectionUtil.isOAuthSignaturePresent(conn);
    }

    @Override
    public boolean endorseRequest(HttpURLConnection conn) throws MiniAuthException, IOException {
        String consumerKey = this.getOAuthSingleConsumerCredentialMapper().getConsumerKey();
        String httpMethod = conn.getRequestMethod();
        URL url = conn.getURL();
        if (url == null) {
            throw new InvalidStateException("Request URL is not set.");
        }
        URI baseURI = BaseURIInfo.createBaseURI((URL)url);
        Map<String, String> authHeader = OAuthURLConnectionUtil.getAuthParams(conn);
        Map formParams = null;
        Map<String, String[]> queryParams = URLConnectionUtil.getQueryParams(conn);
        OAuthOutgoingRequest outgoingRequest = new OAuthOutgoingRequestBuilder().setHttpMethod(httpMethod).setBaseURI(baseURI).setAuthHeader(authHeader).setFormParams(formParams).setQueryParams(queryParams).setConsumerKey(consumerKey).build();
        boolean endorsed = this.endorserService.endorse((OutgoingRequest)outgoingRequest);
        if (!endorsed) {
            throw new InternalErrorException("Failed to endorse the request due to unknown errors.");
        }
        String transmissionType = outgoingRequest.getAuthParamTransmissionType();
        if ("header".equals(transmissionType)) {
            String authHeaderStr = outgoingRequest.getAuthHeaderAuthorizationString();
            conn.setRequestProperty("Authorization", authHeaderStr);
        } else {
            if ("query".equals(transmissionType)) {
                throw new InvalidInputException("Query string cannot be used to include the OAuth signature. ");
            }
            if ("form".equals(transmissionType)) {
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                String formBody = outgoingRequest.getFormParamString();
                OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
                out.write(formBody);
            } else {
                throw new InternalErrorException("Not supported/implemented transmissionType: " + transmissionType);
            }
        }
        return endorsed;
    }
}

