/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.web.oauth.util;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.miniauth.MiniAuthException;
import org.miniauth.oauth.util.OAuthSignatureUtil;
import org.miniauth.oauth.util.ParameterTransmissionUtil;
import org.miniauth.util.AuthHeaderUtil;
import org.miniauth.web.util.ServletRequestUtil;

public final class OAuthServletRequestUtil {
    private static final Logger log = Logger.getLogger(OAuthServletRequestUtil.class.getName());

    private OAuthServletRequestUtil() {
    }

    public static boolean isOAuthParamPresent(HttpServletRequest request) throws MiniAuthException {
        if (request == null) {
            return false;
        }
        Map params = request.getParameterMap();
        if (params == null) {
            return false;
        }
        return OAuthSignatureUtil.containsAnyOAuthParam((Map)params);
    }

    public static boolean isOAuthSignaturePresent(HttpServletRequest request) {
        if (request == null) {
            return false;
        }
        Map params = request.getParameterMap();
        if (params == null) {
            return false;
        }
        return params.containsKey("oauth_signature");
    }

    public static String getOAuthParamTransmissionType(HttpServletRequest request) throws MiniAuthException, IOException {
        Map<String, String> authHeader = OAuthServletRequestUtil.getAuthParams(request);
        Map requestParams = request.getParameterMap();
        Map<String, String[]> queryParams = ServletRequestUtil.getQueryParams(request);
        Map<String, String[]> formParams = ServletRequestUtil.getFormParams(request);
        String transmissionType = ParameterTransmissionUtil.getTransmissionType(authHeader, formParams, queryParams);
        if (log.isLoggable(Level.FINER)) {
            log.finer("transmissionType = " + transmissionType);
        }
        return transmissionType;
    }

    public static Map<String, String> getAuthParams(HttpServletRequest request) throws MiniAuthException {
        String authHeaderValue = request.getHeader("Authorization");
        Map authParams = AuthHeaderUtil.parseAuthParamsFromAuthorizationString((String)authHeaderValue, (String)"OAuth");
        return authParams;
    }
}

