/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.web.oauth.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.oauth.common.OAuthParamMap;
import org.miniauth.oauth.util.OAuthSignatureUtil;
import org.miniauth.oauth.util.ParameterTransmissionUtil;
import org.miniauth.util.AuthHeaderUtil;
import org.miniauth.web.util.URLConnectionUtil;

public final class OAuthURLConnectionUtil {
    private static final Logger log = Logger.getLogger(OAuthURLConnectionUtil.class.getName());

    private OAuthURLConnectionUtil() {
    }

    public static boolean isOAuthParamPresent(HttpURLConnection conn) throws MiniAuthException, IOException {
        if (conn == null) {
            return false;
        }
        Map<String, String[]> params = URLConnectionUtil.getRequestParams(conn);
        if (params == null) {
            return false;
        }
        return OAuthSignatureUtil.containsAnyOAuthParam(params);
    }

    public static boolean isOAuthSignaturePresent(HttpURLConnection conn) throws MiniAuthException, IOException {
        if (conn == null) {
            return false;
        }
        Map<String, String[]> params = URLConnectionUtil.getRequestParams(conn);
        if (params == null) {
            return false;
        }
        return params.containsKey("oauth_signature");
    }

    public static String getOAuthSignature(HttpURLConnection conn) throws MiniAuthException, IOException {
        Map<String, String> authHeader = OAuthURLConnectionUtil.getAuthParams(conn);
        Map<String, String[]> formParams = URLConnectionUtil.getFormParams(conn);
        Map<String, String[]> queryParams = URLConnectionUtil.getQueryParams(conn);
        Map oauthParams = OAuthSignatureUtil.getOAuthParams(authHeader, formParams, queryParams);
        OAuthParamMap oauthParamMap = new OAuthParamMap(oauthParams);
        String signature = oauthParamMap.getSignature();
        if (log.isLoggable(Level.FINER)) {
            log.finer("signature = " + signature);
        }
        return signature;
    }

    public static String getOAuthParamTransmissionType(HttpURLConnection conn) throws MiniAuthException, IOException {
        Map<String, String> authHeader = OAuthURLConnectionUtil.getAuthParams(conn);
        Map<String, String[]> formParams = URLConnectionUtil.getFormParams(conn);
        Map<String, String[]> queryParams = URLConnectionUtil.getQueryParams(conn);
        String transmissionType = ParameterTransmissionUtil.getTransmissionType(authHeader, formParams, queryParams);
        if (log.isLoggable(Level.FINER)) {
            log.finer("transmissionType = " + transmissionType);
        }
        return transmissionType;
    }

    public static Map<String, String> getAuthParams(HttpURLConnection conn) throws MiniAuthException {
        String authHeaderValue = conn.getRequestProperty("Authorization");
        Map authParams = AuthHeaderUtil.parseAuthParamsFromAuthorizationString((String)authHeaderValue, (String)"OAuth");
        return authParams;
    }
}

