/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.factory.mock;

import java.util.logging.Logger;
import org.miniclient.ApiServiceClient;
import org.miniclient.ApiUserClient;
import org.miniclient.ResourceClient;
import org.miniclient.factory.ApiUserClientFactory;
import org.miniclient.factory.ClientFactory;
import org.miniclient.maker.ApiUserClientMaker;
import org.miniclient.maker.mock.MockApiUserClientMaker;
import org.miniclient.mock.MockApiUserClient;

public class MockApiUserClientFactory
implements ApiUserClientFactory,
ClientFactory {
    private static final Logger log = Logger.getLogger(MockApiUserClientFactory.class.getName());
    private ApiUserClientMaker apiUserClientMaker = this.makeApiUserClientMaker();

    protected MockApiUserClientFactory() {
    }

    public static MockApiUserClientFactory getInstance() {
        return MockApiUserClientFactoryHolder.INSTANCE;
    }

    protected ApiUserClient makeApiUserClient(String resourceBaseUrl) {
        return new MockApiUserClient(resourceBaseUrl){};
    }

    protected ApiUserClientMaker makeApiUserClientMaker() {
        return MockApiUserClientMaker.getInstance();
    }

    public ResourceClient createClient(String resourceBaseUrl) {
        return this.makeApiUserClient(resourceBaseUrl);
    }

    public ApiServiceClient makeServiceClient(String resourceBaseUrl) {
        return this.apiUserClientMaker.makeServiceClient(resourceBaseUrl);
    }

    public String toString() {
        return "MockApiUserClientFactory [apiUserClientMaker=" + this.apiUserClientMaker + "]";
    }

    private static final class MockApiUserClientFactoryHolder {
        private static final MockApiUserClientFactory INSTANCE = new MockApiUserClientFactory(){};

        private MockApiUserClientFactoryHolder() {
        }
    }
}

