/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.factory.mock;

import java.util.logging.Logger;
import org.miniclient.ResourceClient;
import org.miniclient.RestServiceClient;
import org.miniclient.RestUserClient;
import org.miniclient.factory.ClientFactory;
import org.miniclient.factory.RestUserClientFactory;
import org.miniclient.maker.RestUserClientMaker;
import org.miniclient.maker.mock.MockRestUserClientMaker;
import org.miniclient.mock.MockRestUserClient;

public class MockRestUserClientFactory
implements RestUserClientFactory,
ClientFactory {
    private static final Logger log = Logger.getLogger(MockRestUserClientFactory.class.getName());
    private RestUserClientMaker restUserClientMaker = this.makeRestUserClientMaker();

    protected MockRestUserClientFactory() {
    }

    public static MockRestUserClientFactory getInstance() {
        return MockRestUserClientFactoryHolder.INSTANCE;
    }

    protected RestUserClient makeRestUserClient(String resourceBaseUrl) {
        return new MockRestUserClient(resourceBaseUrl);
    }

    protected RestUserClientMaker makeRestUserClientMaker() {
        return MockRestUserClientMaker.getInstance();
    }

    public ResourceClient createClient(String resourceBaseUrl) {
        return this.makeRestUserClient(resourceBaseUrl);
    }

    public RestServiceClient makeServiceClient(String resourceBaseUrl) {
        return this.restUserClientMaker.makeServiceClient(resourceBaseUrl);
    }

    public String toString() {
        return "MockRestUserClientFactory [restUserClientMaker=" + this.restUserClientMaker + "]";
    }

    private static final class MockRestUserClientFactoryHolder {
        private static final MockRestUserClientFactory INSTANCE = new MockRestUserClientFactory(){};

        private MockRestUserClientFactoryHolder() {
        }
    }
}

