/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.maker.mock;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.RestServiceClient;
import org.miniclient.common.AuthRefreshPolicy;
import org.miniclient.common.AutoRedirectPolicy;
import org.miniclient.common.CacheControlPolicy;
import org.miniclient.common.ClientCachePolicy;
import org.miniclient.common.CrudMethodFilter;
import org.miniclient.common.DataAccessClient;
import org.miniclient.common.RequestRetryPolicy;
import org.miniclient.common.mock.MockAuthRefreshPolicy;
import org.miniclient.common.mock.MockAutoRedirectPolicy;
import org.miniclient.common.mock.MockCacheControlPolicy;
import org.miniclient.common.mock.MockClientCachePolicy;
import org.miniclient.common.mock.MockCrudMethodFilter;
import org.miniclient.common.mock.MockDataAccessClient;
import org.miniclient.common.mock.MockRequestRetryPolicy;
import org.miniclient.maker.ApiServiceClientMaker;
import org.miniclient.mock.MockRestServiceClient;

public class MockApiServiceClientMaker
implements ApiServiceClientMaker {
    private static final Logger log = Logger.getLogger(MockApiServiceClientMaker.class.getName());

    protected MockApiServiceClientMaker() {
    }

    public static MockApiServiceClientMaker getInstance() {
        return MockApiServiceClientMakerHolder.INSTANCE;
    }

    public RestServiceClient makeRestClient(String resourceBaseUrl) {
        if (log.isLoggable(Level.INFO)) {
            log.info("makeRestClient() called!!! with  resourceBaseUrl = " + resourceBaseUrl);
        }
        return new MockRestServiceClient(resourceBaseUrl);
    }

    public CrudMethodFilter makeCrudMethodFilter() {
        return new MockCrudMethodFilter();
    }

    public DataAccessClient makeDataAccessClient() {
        return new MockDataAccessClient();
    }

    public AuthRefreshPolicy makeAuthRefreshPolicy() {
        return new MockAuthRefreshPolicy();
    }

    public RequestRetryPolicy makeRequestRetryPolicy() {
        return new MockRequestRetryPolicy();
    }

    public ClientCachePolicy makeClientCachePolicy() {
        return new MockClientCachePolicy();
    }

    public CacheControlPolicy makeCacheControlPolicy() {
        return new MockCacheControlPolicy();
    }

    public AutoRedirectPolicy makeAutoRedirectPolicy() {
        return new MockAutoRedirectPolicy();
    }

    public String toString() {
        return "MockApiServiceClientMaker []";
    }

    private static class MockApiServiceClientMakerHolder {
        private static final MockApiServiceClientMaker INSTANCE = new MockApiServiceClientMaker();

        private MockApiServiceClientMakerHolder() {
        }
    }
}

