/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.mock;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.RestApiException;
import org.miniclient.RestApiServiceClient;
import org.miniclient.credential.UserCredential;
import org.miniclient.impl.AbstractRestApiServiceClient;
import org.miniclient.proxy.DecoratedRestApiServiceClient;

public class MockRestApiServiceClient
extends AbstractRestApiServiceClient
implements DecoratedRestApiServiceClient,
Serializable {
    private static final Logger log = Logger.getLogger(MockRestApiServiceClient.class.getName());
    private static final long serialVersionUID = 1L;
    private final RestApiServiceClient decoratedClient;

    public MockRestApiServiceClient() {
        this(null);
    }

    private MockRestApiServiceClient(RestApiServiceClient decoratedClient) {
        this.decoratedClient = decoratedClient;
    }

    public Map<String, Object> get(UserCredential credential, String id, Map<String, Object> params) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestApiServiceClient.get(): credential = " + credential + "; id = " + id + "; params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.get(credential, id, params);
        }
        return super.get(credential, id, params);
    }

    public Map<String, Object> post(UserCredential credential, Object inputData) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestApiServiceClient.post(): credential = " + credential + "; inputData = " + inputData);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.post(credential, inputData);
        }
        return super.post(credential, inputData);
    }

    public Map<String, Object> put(UserCredential credential, Object inputData, String id) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestApiServiceClient.put(): credential = " + credential + "; inputData = " + inputData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.put(credential, inputData, id);
        }
        return super.put(credential, inputData, id);
    }

    public Map<String, Object> patch(UserCredential credential, Object partialData, String id) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestApiServiceClient.patch(): credential = " + credential + "; partialData = " + partialData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.patch(credential, partialData, id);
        }
        return super.patch(credential, partialData, id);
    }

    public Map<String, Object> delete(UserCredential credential, String id, Map<String, Object> params) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestApiServiceClient.delete(): credential = " + credential + "; id = " + id + "; params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.delete(credential, id, params);
        }
        return super.delete(credential, id, params);
    }

    public Object get(UserCredential credential, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestApiServiceClient.get(): credential = " + credential + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.get(credential, id);
        }
        return super.get(credential, id);
    }

    public List<Object> list(UserCredential credential, Map<String, Object> params) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestApiServiceClient.list(): credential = " + credential + "; params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.list(credential, params);
        }
        return super.list(credential, params);
    }

    public List<String> keys(UserCredential credential, Map<String, Object> params) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestApiServiceClient.keys(): credential = " + credential + "; params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.keys(credential, params);
        }
        return super.keys(credential, params);
    }

    public Object create(UserCredential credential, Object inputData) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestApiServiceClient.create(): credential = " + credential + "; inputData = " + inputData);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.create(credential, inputData);
        }
        return super.create(credential, inputData);
    }

    public Object create(UserCredential credential, Object inputData, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestApiServiceClient.create(): credential = " + credential + "; inputData = " + inputData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.create(credential, inputData, id);
        }
        return super.create(credential, inputData, id);
    }

    public Object update(UserCredential credential, Object inputData, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestApiServiceClient.update(): credential = " + credential + "; inputData = " + inputData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.update(credential, inputData, id);
        }
        return super.update(credential, inputData, id);
    }

    public Object modify(UserCredential credential, Object partialData, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestApiServiceClient.modify(): credential = " + credential + "; partialData = " + partialData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.modify(credential, partialData, id);
        }
        return super.modify(credential, partialData, id);
    }

    public boolean delete(UserCredential credential, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestApiServiceClient.delete(): credential = " + credential + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.delete(credential, id);
        }
        return super.delete(credential, id);
    }

    public int delete(UserCredential credential, Map<String, Object> params) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestApiServiceClient.delete(): credential = " + credential + "; params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.delete(credential, params);
        }
        return super.delete(credential, params);
    }

    public String toString() {
        return "MockRestApiServiceClient [decoratedClient=" + this.decoratedClient + ", getRestServiceClient()=" + this.getRestServiceClient() + ", getApiServiceClient()=" + this.getApiServiceClient() + ", getResourceBaseUrl()=" + this.getResourceBaseUrl() + ", getClientCredential()=" + this.getClientCredential() + ", getRestServiceAuthRefreshPolicy()=" + this.getRestServiceAuthRefreshPolicy() + ", getRestServiceRequestRetryPolicy()=" + this.getRestServiceRequestRetryPolicy() + ", getRestServiceClientCachePolicy()=" + this.getRestServiceClientCachePolicy() + ", getRestServiceAutoRedirectPolicy()=" + this.getRestServiceAutoRedirectPolicy() + ", getRequiredScopes()=" + this.getRequiredScopes() + ", getAuthRefreshPolicy()=" + this.getAuthRefreshPolicy() + ", getRequestRetryPolicy()=" + this.getRequestRetryPolicy() + ", getClientCachePolicy()=" + this.getClientCachePolicy() + ", getAutoRedirectPolicy()=" + this.getAutoRedirectPolicy() + "]";
    }
}

