/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.mock;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.RestServiceClient;
import org.miniclient.common.ResourceUrlBuilder;
import org.miniclient.credential.UserCredential;
import org.miniclient.credential.impl.AbstractUserCredential;
import org.miniclient.impl.AbstractRestServiceClient;
import org.miniclient.maker.RestServiceClientMaker;
import org.miniclient.maker.mock.MockRestServiceClientMaker;
import org.miniclient.proxy.DecoratedRestServiceClient;
import org.miniclient.util.ResponseUtil;

public class MockRestServiceClient
extends AbstractRestServiceClient
implements DecoratedRestServiceClient,
ResourceUrlBuilder,
Serializable {
    private static final Logger log = Logger.getLogger(MockRestServiceClient.class.getName());
    private static final long serialVersionUID = 1L;
    private final RestServiceClient decoratedClient;

    public MockRestServiceClient(RestServiceClient decoratedClient) {
        this(decoratedClient, decoratedClient != null ? decoratedClient.getResourceBaseUrl() : null);
    }

    public MockRestServiceClient(String resourceBaseUrl) {
        this(null, resourceBaseUrl);
    }

    private MockRestServiceClient(RestServiceClient decoratedClient, String resourceBaseUrl) {
        super(resourceBaseUrl);
        this.decoratedClient = decoratedClient;
    }

    protected void init() {
        super.init();
        this.setAuthCredentialRequired(false);
        super.setDefaultAuthCredential((UserCredential)new AbstractUserCredential(){});
        this.setRequestFormat("JSON");
        this.setResponseFormat("JSON");
        this.setTimeoutSeconds(10);
    }

    protected RestServiceClientMaker makeRestServiceClientMaker() {
        return MockRestServiceClientMaker.getInstance();
    }

    protected Map<String, Object> process(String method, UserCredential userCredential, Object inputData, String id, Map<String, Object> params, boolean retrying) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestServiceClient.get(): method = " + method + "; userCredential = " + userCredential + "; inputData" + inputData + "; id = " + id + "; params = " + params);
        }
        String endpointUrl = null;
        int statusCode = 0;
        Serializable payload = null;
        String location = null;
        Object errorCode = null;
        Object errorMessage = null;
        Map response = null;
        switch (method) {
            case "GET": {
                endpointUrl = this.getResourceGetUrl(id, params);
                statusCode = 200;
                if (id != null && !id.isEmpty()) {
                    HashMap<String, String> obj1 = new HashMap<String, String>();
                    obj1.put("name", "value");
                    payload = obj1;
                    break;
                }
                ArrayList list1 = new ArrayList();
                HashMap<String, String> o1 = new HashMap<String, String>();
                o1.put("name1", "value1");
                o1.put("name1a", "value1a");
                list1.add(o1);
                HashMap<String, String> o2 = new HashMap<String, String>();
                o2.put("name2", "value2");
                o2.put("name2a", "value2a");
                list1.add(o2);
                payload = list1;
                break;
            }
            case "POST": {
                endpointUrl = this.getResourcePostUrl();
                statusCode = 200;
                HashMap<String, String> obj2 = new HashMap<String, String>();
                obj2.put("name", "value");
                payload = obj2;
                break;
            }
            case "PUT": {
                endpointUrl = this.getResourcePutUrl(id);
                statusCode = 200;
                HashMap<String, String> obj3 = new HashMap<String, String>();
                obj3.put("name", "value");
                payload = obj3;
                break;
            }
            case "PATCH": {
                endpointUrl = this.getResourcePatchUrl(id);
                statusCode = 200;
                HashMap<String, String> obj4 = new HashMap<String, String>();
                obj4.put("name", "value");
                payload = obj4;
                break;
            }
            case "DELETE": {
                endpointUrl = this.getResourceDeleteUrl(id, params);
                statusCode = 200;
                if (id != null && !id.isEmpty()) {
                    payload = Boolean.valueOf(true);
                    break;
                }
                payload = 10;
                break;
            }
        }
        response = ResponseUtil.buildResponse((String)endpointUrl, (int)statusCode, payload, location);
        return response;
    }

    public Map<String, Object> get(UserCredential credential, String id, Map<String, Object> params) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestServiceClient.get(): credential = " + credential + "; id = " + id + "; params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.get(credential, id, params);
        }
        return super.get(credential, id, params);
    }

    public Map<String, Object> post(UserCredential credential, Object inputData) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestServiceClient.post(): credential = " + credential + "; inputData = " + inputData);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.post(credential, inputData);
        }
        return super.post(credential, inputData);
    }

    public Map<String, Object> put(UserCredential credential, Object inputData, String id) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestServiceClient.put(): credential = " + credential + "; inputData = " + inputData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.put(credential, inputData, id);
        }
        return super.put(credential, inputData, id);
    }

    public Map<String, Object> patch(UserCredential credential, Object partialData, String id) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestServiceClient.patch(): credential = " + credential + "; partialData = " + partialData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.patch(credential, partialData, id);
        }
        return super.patch(credential, partialData, id);
    }

    public Map<String, Object> delete(UserCredential credential, String id, Map<String, Object> params) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestServiceClient.delete(): credential = " + credential + "; id = " + id + "; params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.delete(credential, id, params);
        }
        return super.delete(credential, id, params);
    }

    public String toString() {
        return "MockRestServiceClient [decoratedClient=" + this.decoratedClient + ", getResourceUrlBuilder()=" + this.getResourceUrlBuilder() + ", getHttpMethodFilter()=" + this.getHttpMethodFilter() + ", getResourceBaseUrl()=" + this.getResourceBaseUrl() + ", getResourcePostUrl()=" + this.getResourcePostUrl() + ", isAuthCredentialRequired()=" + this.isAuthCredentialRequired() + ", getDefaultAuthCredential()=" + this.getDefaultAuthCredential() + ", getClientCredential()=" + this.getClientCredential() + ", getRequiredScopes()=" + this.getRequiredScopes() + ", getRequestFormat()=" + this.getRequestFormat() + ", getResponseFormat()=" + this.getResponseFormat() + ", getTimeoutSeconds()=" + this.getTimeoutSeconds() + ", getAuthRefreshPolicy()=" + this.getAuthRefreshPolicy() + ", getRequestRetryPolicy()=" + this.getRequestRetryPolicy() + ", getClientCachePolicy()=" + this.getClientCachePolicy() + ", getAutoRedirectPolicy()=" + this.getAutoRedirectPolicy() + "]";
    }
}

