/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.mock;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.RestServiceClient;
import org.miniclient.RestUserClient;
import org.miniclient.common.ResourceUrlBuilder;
import org.miniclient.credential.UserCredential;
import org.miniclient.impl.AbstractRestUserClient;
import org.miniclient.maker.RestUserClientMaker;
import org.miniclient.maker.mock.MockRestUserClientMaker;
import org.miniclient.proxy.DecoratedRestUserClient;

public class MockRestUserClient
extends AbstractRestUserClient
implements DecoratedRestUserClient,
ResourceUrlBuilder,
Serializable {
    private static final Logger log = Logger.getLogger(MockRestUserClient.class.getName());
    private static final long serialVersionUID = 1L;
    private final RestUserClient decoratedClient;

    public MockRestUserClient(String resourceBaseUrl) {
        this(resourceBaseUrl, null);
    }

    public MockRestUserClient(String resourceBaseUrl, UserCredential userCredential) {
        super(resourceBaseUrl, userCredential);
        this.decoratedClient = null;
    }

    public MockRestUserClient(RestServiceClient restServiceClient) {
        this(restServiceClient, null);
    }

    public MockRestUserClient(RestServiceClient restServiceClient, UserCredential userCredential) {
        super(restServiceClient, userCredential);
        this.decoratedClient = null;
    }

    public MockRestUserClient(RestUserClient decoratedClient) {
        super((String)null);
        this.decoratedClient = decoratedClient;
    }

    protected RestUserClientMaker makeRestUserClientMaker() {
        return MockRestUserClientMaker.getInstance();
    }

    public Map<String, Object> get(String id, Map<String, Object> params) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestUserClient.get(): id = " + id + "; params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.get(id, params);
        }
        return super.get(id, params);
    }

    public Map<String, Object> post(Object inputData) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestUserClient.post(): inputData = " + inputData);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.post(inputData);
        }
        return super.post(inputData);
    }

    public Map<String, Object> put(Object inputData, String id) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestUserClient.put(): inputData = " + inputData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.put(inputData, id);
        }
        return super.put(inputData, id);
    }

    public Map<String, Object> patch(Object partialData, String id) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestUserClient.patch(): partialData = " + partialData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.patch(partialData, id);
        }
        return super.patch(partialData, id);
    }

    public Map<String, Object> delete(String id, Map<String, Object> params) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockRestUserClient.delete(): id = " + id + "; params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.delete(id, params);
        }
        return super.delete(id, params);
    }

    public String toString() {
        return "MockRestUserClient [decoratedClient=" + this.decoratedClient + ", getRestServiceClient()=" + this.getRestServiceClient() + ", getResourceBaseUrl()=" + this.getResourceBaseUrl() + ", getResourcePostUrl()=" + this.getResourcePostUrl() + ", getAuthRefreshPolicy()=" + this.getAuthRefreshPolicy() + ", getRequestRetryPolicy()=" + this.getRequestRetryPolicy() + ", getClientCachePolicy()=" + this.getClientCachePolicy() + ", getAutoRedirectPolicy()=" + this.getAutoRedirectPolicy() + ", getUserCredential()=" + this.getUserCredential() + ", isAccessAllowed()=" + this.isAccessAllowed() + "]";
    }
}

