/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.mock;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.ApiServiceClient;
import org.miniclient.RestApiException;
import org.miniclient.credential.UserCredential;
import org.miniclient.impl.AbstractApiServiceClient;
import org.miniclient.maker.ApiServiceClientMaker;
import org.miniclient.maker.mock.MockApiServiceClientMaker;
import org.miniclient.proxy.DecoratedApiServiceClient;

public class MockApiServiceClient
extends AbstractApiServiceClient
implements DecoratedApiServiceClient,
Serializable {
    private static final Logger log = Logger.getLogger(MockApiServiceClient.class.getName());
    private static final long serialVersionUID = 1L;
    private final ApiServiceClient decoratedClient;

    public MockApiServiceClient(ApiServiceClient decoratedClient) {
        this(decoratedClient, decoratedClient != null ? decoratedClient.getResourceBaseUrl() : null);
    }

    public MockApiServiceClient(String resourceBaseUrl) {
        this(null, resourceBaseUrl);
    }

    private MockApiServiceClient(ApiServiceClient decoratedClient, String resourceBaseUrl) {
        super(resourceBaseUrl);
        this.decoratedClient = decoratedClient;
    }

    protected ApiServiceClientMaker makeApiServiceClientMaker() {
        log.info("MockApiServiceClient.makeApiServiceClientMaker() called!!!!");
        return MockApiServiceClientMaker.getInstance();
    }

    public Object get(UserCredential credential, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockApiServiceClient.get(): credential = " + credential + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.get(credential, id);
        }
        return super.get(credential, id);
    }

    public List<Object> list(UserCredential credential, Map<String, Object> params) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockApiServiceClient.list(): credential = " + credential + "; params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.list(credential, params);
        }
        return super.list(credential, params);
    }

    public List<String> keys(UserCredential credential, Map<String, Object> params) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockApiServiceClient.keys(): credential = " + credential + "; params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.keys(credential, params);
        }
        return super.keys(credential, params);
    }

    public Object create(UserCredential credential, Object inputData) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockApiServiceClient.create(): credential = " + credential + "; inputData = " + inputData);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.create(credential, inputData);
        }
        return super.create(credential, inputData);
    }

    public Object create(UserCredential credential, Object inputData, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockApiServiceClient.create(): credential = " + credential + "; inputData = " + inputData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.create(credential, inputData, id);
        }
        return super.create(credential, inputData, id);
    }

    public Object update(UserCredential credential, Object inputData, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockApiServiceClient.update(): credential = " + credential + "; inputData = " + inputData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.update(credential, inputData, id);
        }
        return super.update(credential, inputData, id);
    }

    public Object modify(UserCredential credential, Object partialData, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockApiServiceClient.modify(): credential = " + credential + "; partialData = " + partialData + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.modify(credential, partialData, id);
        }
        return super.modify(credential, partialData, id);
    }

    public boolean delete(UserCredential credential, String id) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockApiServiceClient.delete(): credential = " + credential + "; id = " + id);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.delete(credential, id);
        }
        return super.delete(credential, id);
    }

    public int delete(UserCredential credential, Map<String, Object> params) throws RestApiException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MockApiServiceClient.delete(): credential = " + credential + "; params = " + params);
        }
        if (this.decoratedClient != null) {
            return this.decoratedClient.delete(credential, params);
        }
        return super.delete(credential, params);
    }

    public String toString() {
        return "MockApiServiceClient [decoratedClient=" + this.decoratedClient + ", getRestServiceClient()=" + this.getRestServiceClient() + ", getCrudMethodFilter()=" + this.getCrudMethodFilter() + ", getListResponseType()=" + this.getListResponseType() + ", getResourceBaseUrl()=" + this.getResourceBaseUrl() + ", getClientCredential()=" + this.getClientCredential() + ", getRestServiceAuthRefreshPolicy()=" + this.getRestServiceAuthRefreshPolicy() + ", getRestServiceRequestRetryPolicy()=" + this.getRestServiceRequestRetryPolicy() + ", getRestServiceClientCachePolicy()=" + this.getRestServiceClientCachePolicy() + ", getRestServiceAutoRedirectPolicy()=" + this.getRestServiceAutoRedirectPolicy() + ", getRequiredScopes()=" + this.getRequiredScopes() + ", getAutoRedirectPolicy()=" + this.getAutoRedirectPolicy() + ", getAuthRefreshPolicy()=" + this.getAuthRefreshPolicy() + ", getRequestRetryPolicy()=" + this.getRequestRetryPolicy() + ", getClientCachePolicy()=" + this.getClientCachePolicy() + "]";
    }
}

