package org.miniclient;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.miniclient.common.CrudMethodFilter;


/**
 * API Client. User-specific.
 *     (That is, these instances are not shared among different users.)
 *
 */
public interface ApiUserClient extends ResourceUserClient, ApiClient, CrudMethodFilter
{
    // TBD: 
    //      Throw RestApiException ?????
    // ..

    // ApiServiceClient getApiServiceClient();
    Object get(String id) throws RestApiException, IOException;
    List<Object> list(Map<String,Object> params) throws RestApiException, IOException;
    List<String> keys(Map<String,Object> params) throws RestApiException, IOException;
    Object create(Object inputData) throws RestApiException, IOException;
    Object create(Object inputData, String id) throws RestApiException, IOException;
    Object update(Object inputData, String id) throws RestApiException, IOException;
    // Partial update/PATCH support...
    Object modify(Object partialtData, String id) throws RestApiException, IOException;
    boolean delete(String id) throws RestApiException, IOException;
    int delete(Map<String,Object> params) throws RestApiException, IOException;
}
