/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.common.impl;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.RestApiException;
import org.miniclient.common.AuthRefreshPolicy;
import org.miniclient.common.UserAuthRefreshHandler;
import org.miniclient.common.exception.RestApiPolicyException;
import org.miniclient.common.impl.AbstractUserAuthRefreshHandler;
import org.miniclient.credential.UserCredential;

public abstract class AbstractAuthRefreshPolicy
implements AuthRefreshPolicy,
Serializable {
    private static final Logger log = Logger.getLogger(AbstractAuthRefreshPolicy.class.getName());
    private static final long serialVersionUID = 1L;
    private boolean refreshBeforeRequest = false;
    private boolean refreshIfFails = false;
    private int futureMarginSecs = 0;
    private UserAuthRefreshHandler authRefreshHandler = this.makeUserAuthRefreshHandler();

    public AbstractAuthRefreshPolicy() {
        this.init();
    }

    protected void init() {
    }

    protected UserAuthRefreshHandler makeUserAuthRefreshHandler() {
        return new AbstractUserAuthRefreshHandler(){};
    }

    @Override
    public boolean isRefreshBeforeRequest() {
        return this.refreshBeforeRequest;
    }

    public void setRefreshBeforeRequest(boolean refreshBeforeRequest) {
        this.refreshBeforeRequest = refreshBeforeRequest;
    }

    @Override
    public boolean isRefreshIfFails() {
        return this.refreshIfFails;
    }

    public void setRefreshIfFails(boolean refreshIfFails) {
        this.refreshIfFails = refreshIfFails;
    }

    @Override
    public int getFutureMarginSeconds() {
        return this.futureMarginSecs;
    }

    public void setFutureMarginSeconds(int futureMarginSecs) {
        this.futureMarginSecs = futureMarginSecs;
    }

    @Override
    public UserAuthRefreshHandler getAuthRefreshHandler() {
        return this.authRefreshHandler;
    }

    public void setAuthRefreshHandler(UserAuthRefreshHandler authRefreshHandler) {
        this.authRefreshHandler = authRefreshHandler;
    }

    @Override
    public boolean isPerformable() {
        return this.authRefreshHandler != null && this.authRefreshHandler.isImeplemented();
    }

    @Override
    public Object perform(Object ... args) throws RestApiException {
        log.fine("BEGIN: perform()");
        if (this.authRefreshHandler == null) {
            log.info("authRefreshHandler is null. perform() not performed.");
            throw new RestApiPolicyException("authRefreshHandler is null. perform() not performed.");
        }
        if (!this.authRefreshHandler.isImeplemented()) {
            log.info("authRefreshHandler is not implemented. perform() not performed.");
            throw new RestApiPolicyException("authRefreshHandler is not implemented. perform() not performed.");
        }
        if (args.length == 0) {
            log.info("No input arg provided. perform() not performed.");
            throw new RestApiPolicyException("No input arg provided. perform() not performed.");
        }
        if (args[0] == null || !(args[0] instanceof UserCredential)) {
            log.info("Input arg is null or an invalid type. perform() not performed.");
            throw new RestApiPolicyException("Input arg is null or an invalid type. perform() not performed.");
        }
        UserCredential userCredential = (UserCredential)args[0];
        Long tokenExpirationTime = userCredential.getExpirationTime();
        if (tokenExpirationTime == null) {
            tokenExpirationTime = 0L;
        }
        Long refreshedTokenExpirationTime = null;
        UserCredential refresedhUserCredential = this.authRefreshHandler.refreshAuthToken(userCredential);
        if (refresedhUserCredential == null) {
            log.warning("Failed to refresh the user credential.");
            throw new RestApiPolicyException("Failed to refresh the user credential.");
        }
        refreshedTokenExpirationTime = refresedhUserCredential.getExpirationTime();
        if (log.isLoggable(Level.FINER)) {
            log.finer("userCredential refreshed: " + refresedhUserCredential);
        }
        return refresedhUserCredential;
    }

    public String toString() {
        return "AbstractAuthRefreshPolicy [refreshBeforeRequest=" + this.refreshBeforeRequest + ", refreshIfFails=" + this.refreshIfFails + ", futureMarginSecs=" + this.futureMarginSecs + ", authRefreshHandler=" + this.authRefreshHandler + "]";
    }
}

