/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.common.impl;

import java.io.Serializable;
import java.util.logging.Logger;
import org.miniclient.common.CrudMethodFilter;
import org.miniclient.common.HttpMethodFilter;
import org.miniclient.common.impl.AbstractHttpMethodFilter;
import org.miniclient.common.impl.AbstractMethodFilter;

public abstract class AbstractCrudMethodFilter
extends AbstractMethodFilter
implements CrudMethodFilter,
Serializable {
    private static final Logger log = Logger.getLogger(AbstractCrudMethodFilter.class.getName());
    private static final long serialVersionUID = 1L;
    private final HttpMethodFilter httpMethodFilter;

    public AbstractCrudMethodFilter() {
        this.getMethodSet().add("get.item");
        this.getMethodSet().add("get.list");
        this.getMethodSet().add("get.keys");
        this.getMethodSet().add("create.item");
        this.getMethodSet().add("update.item");
        this.getMethodSet().add("delete.item");
        this.getMethodSet().add("delete.list");
        this.httpMethodFilter = null;
    }

    public AbstractCrudMethodFilter(HttpMethodFilter httpMethodFilter) {
        this.httpMethodFilter = httpMethodFilter != null ? httpMethodFilter : new AbstractHttpMethodFilter(){};
    }

    @Override
    public boolean isMethodSupported(String methodName) {
        if (this.httpMethodFilter == null) {
            return super.isMethodSupported(methodName);
        }
        switch (methodName) {
            case "get.item": 
            case "get.list": 
            case "get.keys": {
                return this.httpMethodFilter.isMethodSupported("GET");
            }
            case "create.item": {
                return this.httpMethodFilter.isMethodSupported("POST") || this.httpMethodFilter.isMethodSupported("PUT");
            }
            case "update.item": {
                return this.httpMethodFilter.isMethodSupported("PUT");
            }
            case "delete.item": 
            case "delete.list": {
                return this.httpMethodFilter.isMethodSupported("DELETE");
            }
        }
        return false;
    }

    @Override
    public boolean setMethodSupported(String methodName) {
        if (this.httpMethodFilter == null) {
            return super.setMethodSupported(methodName);
        }
        switch (methodName) {
            case "get.item": 
            case "get.list": 
            case "get.keys": {
                return ((AbstractHttpMethodFilter)this.httpMethodFilter).setMethodSupported("GET");
            }
            case "create.item": {
                return ((AbstractHttpMethodFilter)this.httpMethodFilter).setMethodSupported("POST") || ((AbstractHttpMethodFilter)this.httpMethodFilter).setMethodSupported("PUT");
            }
            case "update.item": {
                return ((AbstractHttpMethodFilter)this.httpMethodFilter).setMethodSupported("PUT");
            }
            case "delete.item": 
            case "delete.list": {
                return ((AbstractHttpMethodFilter)this.httpMethodFilter).setMethodSupported("DELETE");
            }
        }
        return false;
    }

    @Override
    public boolean setMethodUnsupported(String methodName) {
        if (this.httpMethodFilter == null) {
            return super.setMethodUnsupported(methodName);
        }
        switch (methodName) {
            case "get.item": 
            case "get.list": 
            case "get.keys": {
                return ((AbstractHttpMethodFilter)this.httpMethodFilter).setMethodUnsupported("GET");
            }
            case "create.item": {
                return ((AbstractHttpMethodFilter)this.httpMethodFilter).setMethodUnsupported("POST") || ((AbstractHttpMethodFilter)this.httpMethodFilter).setMethodUnsupported("PUT");
            }
            case "update.item": {
                return ((AbstractHttpMethodFilter)this.httpMethodFilter).setMethodUnsupported("PUT");
            }
            case "delete.item": 
            case "delete.list": {
                return ((AbstractHttpMethodFilter)this.httpMethodFilter).setMethodUnsupported("DELETE");
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return "AbstractCrudMethodFilter [httpMethodFilter=" + this.httpMethodFilter + "]";
    }
}

