/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.common.impl;

import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniclient.common.ResourceUrlBuilder;
import org.miniclient.util.ResourceUrlUtil;

public abstract class AbstractResourceUrlBuilder
implements ResourceUrlBuilder,
Serializable {
    private static final Logger log = Logger.getLogger(AbstractResourceUrlBuilder.class.getName());
    private static final long serialVersionUID = 1L;
    private String resourceBaseUrl;
    private String parentResourceBaseUrl;
    private String parentResourceId;
    private String resourceName;
    private String suffix;

    public AbstractResourceUrlBuilder(String resourceBaseUrl) {
        this(resourceBaseUrl, null);
    }

    public AbstractResourceUrlBuilder(String resourceBaseUrl, String suffix) {
        if (resourceBaseUrl != null) {
            this.resourceBaseUrl = resourceBaseUrl;
        } else {
            log.warning("Invalid resourceBaseUrl.");
            this.resourceBaseUrl = "/";
        }
        this.suffix = suffix;
        this.init();
    }

    public AbstractResourceUrlBuilder(String parentResourceBaseUrl, String parentResourceId, String resourceName) {
        this(parentResourceBaseUrl, parentResourceId, resourceName, null);
    }

    public AbstractResourceUrlBuilder(String parentResourceBaseUrl, String parentResourceId, String resourceName, String suffix) {
        this.parentResourceBaseUrl = parentResourceBaseUrl;
        this.parentResourceId = parentResourceId;
        this.resourceName = resourceName;
        this.resourceBaseUrl = AbstractResourceUrlBuilder.buildBaseUrl(parentResourceBaseUrl, parentResourceId, resourceName);
        this.init();
    }

    protected void init() {
    }

    public static String buildBaseUrl(String parentResourceBaseUrl, String parentResourceId, String resourceName) {
        String url1 = ResourceUrlUtil.buildUrl(parentResourceBaseUrl, parentResourceId);
        String url2 = ResourceUrlUtil.buildUrl(url1, resourceName);
        return url2;
    }

    @Override
    public String getResourceBaseUrl() {
        return this.resourceBaseUrl;
    }

    public void setResourceBaseUrl(String resourceBaseUrl) {
        this.resourceBaseUrl = resourceBaseUrl;
    }

    public String getParentResourceBaseUrl() {
        return this.parentResourceBaseUrl;
    }

    public void setParentResourceBaseUrl(String parentResourceBaseUrl) {
        this.parentResourceBaseUrl = parentResourceBaseUrl;
        this.resourceBaseUrl = AbstractResourceUrlBuilder.buildBaseUrl(parentResourceBaseUrl, this.parentResourceId, this.resourceName);
    }

    public String getParentResourceId() {
        return this.parentResourceId;
    }

    public void setParentResourceId(String parentResourceId) {
        this.parentResourceId = parentResourceId;
        this.resourceBaseUrl = AbstractResourceUrlBuilder.buildBaseUrl(this.parentResourceBaseUrl, parentResourceId, this.resourceName);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
        this.resourceBaseUrl = AbstractResourceUrlBuilder.buildBaseUrl(this.parentResourceBaseUrl, this.parentResourceId, resourceName);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getResourceGetUrl(String id) {
        return this.getResourceGetUrl(id, null);
    }

    public String getResourceGetUrl(Map<String, Object> params) {
        return this.getResourceGetUrl(null, params);
    }

    @Override
    public String getResourceGetUrl(String id, Map<String, Object> params) {
        return AbstractResourceUrlBuilder.buildResourceGetUrl(this.resourceBaseUrl, id, params, this.suffix);
    }

    public static String buildResourceGetUrl(String baseUrl, String id, Map<String, Object> params, String sufx) {
        String url = null;
        url = ResourceUrlUtil.buildUrl(baseUrl, id, sufx, params);
        if (log.isLoggable(Level.FINER)) {
            log.finer("url = " + url);
        }
        return url;
    }

    @Override
    public String getResourcePostUrl() {
        return AbstractResourceUrlBuilder.buildResourcePostUrl(this.resourceBaseUrl, this.suffix);
    }

    public static String buildResourcePostUrl(String baseUrl, String sufx) {
        String url = ResourceUrlUtil.buildUrl(baseUrl, null, sufx);
        if (log.isLoggable(Level.FINER)) {
            log.finer("url = " + url);
        }
        return url;
    }

    @Override
    public String getResourcePutUrl(String id) {
        return AbstractResourceUrlBuilder.buildResourcePutUrl(this.resourceBaseUrl, id, this.suffix);
    }

    public static String buildResourcePutUrl(String baseUrl, String id, String sufx) {
        String url = ResourceUrlUtil.buildUrl(baseUrl, id, sufx);
        if (log.isLoggable(Level.FINER)) {
            log.finer("url = " + url);
        }
        return url;
    }

    @Override
    public String getResourcePatchUrl(String id) {
        return AbstractResourceUrlBuilder.buildResourcePatchUrl(this.resourceBaseUrl, id, this.suffix);
    }

    public static String buildResourcePatchUrl(String baseUrl, String id, String sufx) {
        String url = ResourceUrlUtil.buildUrl(baseUrl, id, sufx);
        if (log.isLoggable(Level.FINER)) {
            log.finer("url = " + url);
        }
        return url;
    }

    public String getResourceDeleteUrl(String id) {
        return this.getResourceDeleteUrl(id, null);
    }

    public String getResourceDeleteUrl(Map<String, Object> params) {
        return this.getResourceDeleteUrl(null, params);
    }

    @Override
    public String getResourceDeleteUrl(String id, Map<String, Object> params) {
        return AbstractResourceUrlBuilder.buildResourceDeleteUrl(this.resourceBaseUrl, id, params, this.suffix);
    }

    public static String buildResourceDeleteUrl(String baseUrl, String id, Map<String, Object> params, String sufx) {
        String url = null;
        url = id != null ? ResourceUrlUtil.buildUrl(baseUrl, id, sufx) : ResourceUrlUtil.buildUrl(baseUrl, null, sufx, params);
        if (log.isLoggable(Level.FINER)) {
            log.finer("url = " + url);
        }
        return url;
    }

    public String toString() {
        return "AbstractResourceUrlBuilder [resourceBaseUrl=" + this.resourceBaseUrl + ", parentResourceBaseUrl=" + this.parentResourceBaseUrl + ", parentResourceId=" + this.parentResourceId + ", resourceName=" + this.resourceName + ", suffix=" + this.suffix + "]";
    }
}

