/*
 * Decompiled with CFR 0.152.
 */
package org.miniclient.core;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public final class HttpMethod {
    private static final Logger log = Logger.getLogger(HttpMethod.class.getName());
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String PATCH = "PATCH";
    public static final String DELETE = "DELETE";
    public static final String HEAD = "HEAD";
    public static final String OPTIONS = "OPTIONS";
    private static Set<String> methodSet = new HashSet<String>();

    private HttpMethod() {
    }

    public static boolean isValid(String methodName) {
        if (methodName == null) {
            return false;
        }
        return methodSet.contains(methodName.toUpperCase());
    }

    static {
        methodSet.add(GET);
        methodSet.add(POST);
        methodSet.add(PUT);
        methodSet.add(DELETE);
    }
}

